/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.http.MDNSServletService;
import com.inet.http.OriginChecker;
import com.inet.http.PluginServlet;
import com.inet.http.security.TrustAllTrustManager;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.mdns.MulticastDNS;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoType;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.shared.diagnostics.shared.DumpWidgetExtension;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.webserver.ListenerConnector;
import com.inet.webserver.ListenerSettings;
import com.inet.webserver.acme.a;
import com.inet.webserver.api.WebServerInfo;
import com.inet.webserver.c;
import com.inet.webserver.d;
import com.inet.webserver.e;
import com.inet.webserver.structure.WebConfigKeys;
import com.inet.webserver.taskplanner.b;
import com.inet.webserver.webconfig.WebConfig;
import com.inet.webserver.webconfig.WebConfigFileManager;
import jakarta.servlet.Filter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.AccessDeniedException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@PluginInfo(id="webserver", internal="jetty-http.jar;jetty-client.jar;jetty-io.jar;jetty-security.jar;jetty-server.jar;jetty-session.jar;jetty-ee11-servlet.jar;jetty-ee11-servlets.jar;jetty-util.jar;jetty-ee11-websocket-jakarta-server.jar;jetty-ee11-websocket-jakarta-client.jar;jetty-ee11-websocket-jakarta-common.jar;jetty-websocket-core-common.jar;jetty-websocket-core-client.jar;jetty-websocket-core-server.jar;jetty-websocket-jetty-api.jar;jetty-ee11-websocket-jetty-server.jar;jetty-ee11-websocket-servlet.jar;acme4j-client.jar;jose4j.jar;bc-fips.jar;bcpkix-fips.jar;bcutil-fips.jar;jetty-http2-server.jar;jetty-http2-common.jar;jetty-http2-hpack.jar;jetty-alpn-server.jar;jetty-alpn-java-server.jar", group="system", flags="core", version="25.10.314", packages="org.eclipse.jetty;com.inet.webserver", optionalDependencies="remotegui;taskplanner;diagnostics;webserver.http3;maintenance;webapi.core", icon="com/inet/webserver/structure/webserver_48.png")
public class WebServerPlugin
implements ServerPlugin {
    private d G;
    private MulticastDNS H;
    private final UUID I = UUID.randomUUID();
    private com.inet.webserver.a J;
    public static final I18nMessages MSG = new I18nMessages("com.inet.webserver.structure.i18n.ConfigStructure", WebServerPlugin.class);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 9910, new Permission[]{Permission.CONFIGURATION}){}, new String[]{"configuration"});
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9130, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner"), Permission.CONFIGURATION}){}, new String[]{"configuration", "taskplanner"});
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9135, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner"), Permission.CONFIGURATION}){}, new String[]{"webapi.core"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(ConfigStructureProvider.class, (Object)new com.inet.webserver.structure.b());
        spm.register(PluginServlet.class, (Object)new a());
        this.J = new com.inet.webserver.a();
        spm.register(OriginChecker.class, (Object)this.J);
        spm.register(Filter.class, (Object)this.J);
        spm.register(Filter.class, (Object)new e());
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                spm.register(JobFactory.class, (Object)new com.inet.webserver.acme.taskplanner.b());
                spm.register(JobFactory.class, (Object)new b());
            }
        });
        spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

            public void vetoFinished(@Nullable VetoType type) {
                if (type == null && WebServerPlugin.this.G != null && !ConfigurationManager.isRecoveryMode()) {
                    ForkJoinPool.commonPool().execute(() -> WebServerPlugin.this.d(WebServerPlugin.this.G.f()));
                }
            }
        });
        spm.register(WebServerInfo.class, (Object)com.inet.webserver.internal.b.U);
        spm.runIfPluginLoaded("diagnostics", () -> new Executable(){

            public void execute() {
                spm.register(DumpWidgetExtension.class, (Object)new com.inet.webserver.internal.a(() -> WebServerPlugin.this.G.j()));
            }
        });
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                spm.register(BackupTask.class, (Object)new com.inet.webserver.maintenance.a());
            }
        });
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                spm.register(WebAPIExtension.class, (Object)new com.inet.webserver.webapi.a());
            }
        });
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "URLCONNECTION_SSRF_FD"}, justification="no security random value; no user input is used")
    public void init(ServerPluginManager spm) {
        try {
            int n;
            Object iOException;
            URLConnection uRLConnection;
            Object object;
            String string;
            Object object3;
            UserManager.getInstance();
            boolean bl = false;
            String string2 = null;
            new WebConfigKeys();
            Properties properties = spm.getStartProperties();
            bl = Boolean.parseBoolean(properties.getProperty("autodetectPort", "false"));
            string2 = properties.getProperty("bindAddress");
            int n2 = Integer.parseInt(properties.getProperty("serverPort", "0"));
            boolean bl2 = n2 <= 0;
            ListenerSettings listenerSettings = new ListenerSettings(bl2, bl, string2);
            if (!bl2) {
                listenerSettings.addPlainConnector(n2, bl, string2);
            }
            if (ConfigurationManager.isRecoveryMode() && !ConfigurationManager.isHelpCenterMode() && Persistence.getRecoveryEnabledInstance().getUID() != null) {
                object3 = ConfigurationManager.getInstance().get(ConfigurationManager.getRecoveryConfiguration());
                ListenerSettings listenerSettings2 = new ListenerSettings((Configuration)object3);
                string = object3 == null ? "/" : object3.get(WebConfigKeys.LISTENER_CONTEXT);
                for (ListenerConnector object4 : listenerSettings2.k()) {
                    object = new URL(object4.a(true) + string);
                    uRLConnection = ((URL)object).openConnection();
                    uRLConnection.setConnectTimeout(5000);
                    uRLConnection.setReadTimeout(5000);
                    TrustAllTrustManager.trustAllCerticates((URLConnection)uRLConnection, (boolean)false);
                    try {
                        iOException = uRLConnection.getInputStream();
                        try {
                            String string3 = uRLConnection.getHeaderField("X-Server-UID");
                            if (!Objects.equals(string3, Persistence.getRecoveryEnabledInstance().getUID())) continue;
                            throw new Error("Server is running on " + String.valueOf(object) + ". Please stop the server first before starting the recovery mananger.");
                        }
                        finally {
                            if (iOException != null) {
                                ((InputStream)iOException).close();
                            }
                        }
                    }
                    catch (IOException iOException2) {}
                }
            }
            this.G = new d(listenerSettings);
            object3 = this.G.f();
            if (!ConfigurationManager.isRecoveryMode()) {
                object3 = this.d((String)object3);
            }
            if ((n = ((String)object3).indexOf("localhost")) != -1) {
                string = NetworkFunctions.getCanonicalLocalHostName();
                object3 = ((String)object3).substring(0, n) + string + ((String)object3).substring(n + 9);
            }
            properties.setProperty("UrlString", (String)object3);
            ConfigKey.SERVER_URL.setDefault((String)object3);
            object3 = (String)ConfigKey.SERVER_URL.getCurrent();
            properties.setProperty("ServerPorts", this.G.i());
            string = this.G.g();
            properties.setProperty("UrlStrings", string);
            this.J.c(string);
            e.c(string);
            try {
                List list = spm.get(MDNSServletService.class);
                if (!list.isEmpty() && !ConfigurationManager.isRecoveryMode()) {
                    if (((String)object3).endsWith("/")) {
                        object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
                    }
                    this.H = new MulticastDNS();
                    String string4 = "n" + Long.toHexString(new Random().nextLong());
                    object = list.iterator();
                    while (object.hasNext()) {
                        uRLConnection = (MDNSServletService)object.next();
                        iOException = uRLConnection.getMDNSServiceType();
                        this.H.publishService((String)iOException, string4 + "." + (String)iOException, n2, (String)object3 + uRLConnection.getPathSpec());
                    }
                }
            }
            catch (Throwable throwable) {
                c.o.warn((Object)throwable);
            }
        }
        catch (IOException iOException) {
            c.o.fatal((Object)iOException);
            iOException.printStackTrace();
            throw new IOError(iOException);
        }
    }

    public void reset() {
        if (this.G != null) {
            this.G.h();
            this.G = null;
        }
        if (this.H != null) {
            this.H.close();
            this.H = null;
        }
    }

    public void restart() {
        if (this.G == null) {
            this.init(ServerPluginManager.getInstance());
        }
    }

    private String d(String object) {
        try {
            String string = (String)com.inet.webserver.b.j.get();
            if (!"/".equals(string)) {
                object = (String)object + EncodingFunctions.encodeUrlPath((String)string);
            }
            URL uRL = new URL((String)object);
            WebConfig webConfig = new WebConfig(uRL, this.I);
            WebConfigFileManager webConfigFileManager = new WebConfigFileManager();
            webConfigFileManager.write(webConfig);
        }
        catch (AccessDeniedException accessDeniedException) {
            c.o.warn((Object)accessDeniedException.getMessage());
        }
        catch (IOException | SecurityException exception) {
            c.o.error((Throwable)exception);
        }
        return object;
    }
}

