/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.server.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.websocket.server.HandshakeRequest;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class JsrHandshakeRequest
implements HandshakeRequest {
    private final ServerUpgradeRequest delegate;
    private final HttpServletRequest httpServletRequest;
    private final Map<String, List<String>> headers;
    private Map<String, List<String>> parameterMap;

    public JsrHandshakeRequest(ServerUpgradeRequest req) {
        this.delegate = req;
        this.httpServletRequest = (HttpServletRequest)req.getAttribute("org.eclipse.jetty.websocket.wrappedRequest");
        this.headers = HttpFields.asMap((HttpFields)this.delegate.getHeaders());
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Object getHttpSession() {
        return this.httpServletRequest.getSession(false);
    }

    public Map<String, List<String>> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, List<String>>();
            Fields requestParams = Request.extractQueryParameters((Request)this.delegate);
            for (String name : requestParams.getNames()) {
                this.parameterMap.compute(name, (key, values) -> {
                    if (values == null) {
                        values = new ArrayList();
                    }
                    values.addAll(requestParams.getValues(name));
                    return values;
                });
            }
            Map<String, String> pathParams = this.getPathParams();
            if (pathParams != null) {
                for (Map.Entry<String, Object> entry : pathParams.entrySet()) {
                    this.parameterMap.compute(entry.getKey(), (key, values) -> {
                        if (values == null) {
                            values = new ArrayList<String>();
                        }
                        values.add((String)entry.getValue());
                        return values;
                    });
                }
            }
            for (Map.Entry<String, Object> entry : this.parameterMap.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
        }
        return this.parameterMap;
    }

    public String getQueryString() {
        return this.delegate.getHttpURI().getQuery();
    }

    public PathSpec getRequestPathSpec() {
        return (PathSpec)this.delegate.getAttribute(PathSpec.class.getName());
    }

    public Map<String, String> getPathParams() {
        return (Map)this.delegate.getAttribute("jakarta.websocket.server.pathParams");
    }

    public URI getRequestURI() {
        return this.delegate.getHttpURI().toURI();
    }

    public Principal getUserPrincipal() {
        return this.httpServletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.httpServletRequest.isUserInRole(role);
    }
}

