/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver.webconfig;

import com.inet.annotations.InternalApi;
import com.inet.classloader.BaseLocator;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.webserver.c;
import com.inet.webserver.webconfig.WebConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class WebConfigFileManager {
    private static final String[] aa = new String[]{"OpenServerGUI.url", "OpenServerGUI.sh"};
    public static final String KEY_PROTOCOL = "PROTOCOL";
    public static final String KEY_ADDRESS = "ADDRESS";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_URL = "URL";
    public static final String KEY_UUID = "UUID";

    public void write(WebConfig webConfig) throws IOException, SecurityException {
        if (webConfig == null) {
            throw new IllegalArgumentException("web config must not be null");
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        URL uRL = webConfig.getUrl();
        arrayList.add((CallSite)((Object)("PROTOCOL " + uRL.getProtocol())));
        arrayList.add((CallSite)((Object)("ADDRESS " + uRL.getHost())));
        arrayList.add((CallSite)((Object)("PORT " + uRL.getPort())));
        arrayList.add((CallSite)((Object)("URL " + String.valueOf(uRL))));
        arrayList.add((CallSite)((Object)("UUID " + String.valueOf(webConfig.UUID()))));
        Path path = WebConfigFileManager.i("webconfig.txt").toPath();
        Files.write(path, arrayList, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        c.o.status((Object)("Saved webconfig.txt to " + path.toRealPath(new LinkOption[0]).toString()));
        this.a(webConfig);
    }

    public WebConfig read() throws IOException {
        String string = null;
        String string2 = null;
        int n = 0;
        UUID uUID = null;
        URL uRL = null;
        List<String> list = Files.readAllLines(WebConfigFileManager.i("webconfig.txt").toPath(), StandardCharsets.ISO_8859_1);
        for (String string3 : list) {
            int n2 = string3.indexOf(32);
            if (n2 < 0) continue;
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            switch (string4) {
                case "PROTOCOL": {
                    string = string5;
                    break;
                }
                case "ADDRESS": {
                    string2 = string5;
                    break;
                }
                case "PORT": {
                    n = Integer.parseInt(string5);
                    break;
                }
                case "URL": {
                    uRL = new URL(string5);
                    break;
                }
                case "UUID": {
                    uUID = UUID.fromString(string5);
                    break;
                }
            }
        }
        if (uRL == null) {
            uRL = new URL(string, string2, n, "/");
        }
        return new WebConfig(uRL, uUID);
    }

    @Nonnull
    public static File getWebConfigFile() throws MalformedURLException {
        return WebConfigFileManager.i("webconfig.txt");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private static File i(String string) throws MalformedURLException {
        URL uRL = BaseLocator.getBaseDirectory().getURL();
        File file = IOFunctions.getFile((URL)uRL);
        return new File(file, string);
    }

    private void a(WebConfig webConfig) throws IOException {
        String string;
        String[] stringArray;
        Object object = webConfig.getUrl().toString();
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        for (String object2 : aa) {
            File i = WebConfigFileManager.i(object2);
            if (!i.exists()) continue;
            List<String> list = Files.readAllLines(i.toPath(), StandardCharsets.ISO_8859_1);
            for (int j = 0; j < list.size(); ++j) {
                Object object3 = list.get(j);
                if (!((String)object3).startsWith("URL=")) continue;
                object3 = "URL=" + (String)object;
                list.set(j, (String)object3);
                Files.write(i.toPath(), list, StandardCharsets.ISO_8859_1, new OpenOption[0]);
            }
        }
        File file = WebConfigFileManager.i("IIS/ClientProxy.vb");
        if (file.exists() && (stringArray = (string = IOFunctions.readAsciiString((File)file)).split("Connect\\(\\\".+\\\"\\)")).length > 1) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(stringArray[0].getBytes(StandardCharsets.ISO_8859_1));
                for (int i = 1; i < stringArray.length; ++i) {
                    fileOutputStream.write("Connect(\"".getBytes(StandardCharsets.ISO_8859_1));
                    fileOutputStream.write(((String)object).toString().getBytes(StandardCharsets.ISO_8859_1));
                    fileOutputStream.write("\")".toString().getBytes(StandardCharsets.ISO_8859_1));
                    fileOutputStream.write(stringArray[i].getBytes(StandardCharsets.ISO_8859_1));
                }
            }
        }
    }

    static void A() {
        try {
            File file = WebConfigFileManager.i("webconfig.txt");
            if (file.isFile()) {
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.print("");
                printWriter.close();
            }
        }
        catch (FileNotFoundException | MalformedURLException iOException) {
            LogManager.getConfigLogger().error((Throwable)iOException);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> WebConfigFileManager.A()));
    }
}

