/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver.webapi.certificates;

import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.error.ErrorCode;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.webserver.b;
import com.inet.webserver.f;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Webserver", description="SSL certificate management operations")
public class a
extends RequestHandlerBase<Void, Void> {
    public a() {
        super(new String[]{"certificates"});
    }

    public String getHelpPageKey() {
        return "webapi.webserver.certificates";
    }

    @Operation(summary="Upload SSL certificates", description="Upload and activate new SSL certificates (public certificate and private key)", responses={@ApiResponse(responseCode="200", description="Certificates uploaded and activated successfully"), @ApiResponse(responseCode="400", description="Invalid certificate files or missing parts", content={@Content(mediaType="text/plain")}), @ApiResponse(responseCode="500", description="Error during certificate activation")})
    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, @Nonnull List<String> list, boolean bl) throws IOException {
        Collection collection = null;
        try {
            collection = httpServletRequest.getParts();
        }
        catch (ServletException | IOException throwable2) {
            throw new ClientMessageException("Could not determine uploaded files", throwable2);
        }
        if (collection == null || collection.size() == 0) {
            throw new ClientMessageException("No files uploaded as parts of the request");
        }
        Certificate certificate = null;
        RSAPrivateKey rSAPrivateKey = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (Part part : collection) {
            if (certificate != null && rSAPrivateKey != null) break;
            InputStream inputStream = part.getInputStream();
            try {
                byte[] byArray3 = IOFunctions.readBytes((InputStream)inputStream);
                URL uRL = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])byArray3);
                try {
                    ArrayList<ConfigValidationMsg> arrayList2 = new ArrayList<ConfigValidationMsg>();
                    certificate = certificate != null ? certificate : f.a(uRL, false, arrayList2);
                    List list2 = arrayList2.stream().filter(configValidationMsg -> ConfigValidationMsg.Type.Invalid.equals((Object)configValidationMsg.getType())).collect(Collectors.toList());
                    if (!list2.isEmpty()) {
                        arrayList2.forEach(configValidationMsg -> hashSet.add(configValidationMsg.getMsg()));
                    } else {
                        byArray = byArray != null ? byArray : (certificate != null ? byArray3 : byArray);
                    }
                }
                catch (Throwable throwable3) {
                    hashSet.add(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable3));
                    arrayList.add(throwable3);
                }
                try {
                    RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey = rSAPrivateKey != null ? rSAPrivateKey : f.b(uRL);
                    byArray2 = byArray2 != null ? byArray2 : (rSAPrivateKey != null ? byArray3 : byArray2);
                }
                catch (Throwable throwable4) {
                    hashSet.add(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable4));
                    LogManager.getConfigLogger().debug((Object)throwable4);
                    arrayList.add(throwable4);
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (certificate == null || rSAPrivateKey == null) {
            if (hashSet.isEmpty()) {
                hashSet.add("The " + (certificate == null ? "certificate" : "private key") + " part is missing");
            }
            arrayList.forEach(throwable -> LogManager.getConfigLogger().debug(throwable));
            throw new ClientMessageException("You have to provide both, public certificate and private key in the same request. The parsing errors were:\n" + String.join((CharSequence)"\n", hashSet));
        }
        Objects.requireNonNull(byArray2);
        Objects.requireNonNull(byArray);
        try {
            f.a(certificate, rSAPrivateKey);
            com.inet.webserver.structure.a.u().a(byArray2);
            com.inet.webserver.structure.a.t().a(byArray);
            f f2 = new f(IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", byArray), IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", byArray2));
            b.a(f2);
        }
        catch (Exception exception) {
            ErrorCode.throwAny((Throwable)exception);
        }
        return null;
    }

    @Operation(summary="Upload SSL certificates", description="Upload and activate new SSL certificates (public certificate and private key)", responses={@ApiResponse(responseCode="200", description="Certificates uploaded and activated successfully"), @ApiResponse(responseCode="400", description="Invalid certificate files or missing parts", content={@Content(mediaType="text/plain")}), @ApiResponse(responseCode="500", description="Error during certificate activation")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, @Nonnull List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, list, bl);
    }
}

