/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver.maintenance;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.error.ErrorCode;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.shared.utils.Version;
import com.inet.webserver.acme.b;
import com.inet.webserver.structure.WebConfigKeys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class a
implements BackupTask {
    public static final I18nMessages MSG = new I18nMessages("com.inet.webserver.maintenance.i18n.maintenance", a.class);
    private final String V = "backup.certificates.properties";

    public String getKey() {
        return "webserver.certificates";
    }

    public String getTitle() {
        return MSG.getMsg("job.displayname", new Object[0]);
    }

    public String getDescription() {
        return MSG.getMsg("job.description", new Object[0]);
    }

    public URL getIconURL() {
        return a.class.getResource("/com/inet/webserver/maintenance/ssl_certificate_32.png");
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN"}, justification="Files accessed by URL are file:// or data: urls are well known and configured by administrative users.")
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        Object object;
        Object object2;
        Object object3;
        progressUpdater.updateProgress(0);
        int n = 0;
        Properties properties = new Properties();
        String string = (String)ConfigKey.LISTENER_SSL_CERTIFICATE.getCurrent();
        String string2 = (String)ConfigKey.LISTENER_SSL_PRIVATEKEY.getCurrent();
        if (!StringFunctions.isEmpty((String)string) && !StringFunctions.isEmpty((String)string2)) {
            object3 = new File(string);
            object2 = new File(string2);
            if (((File)object3).exists() && ((File)object2).exists()) {
                properties.put(ConfigKey.LISTENER_SSL_CERTIFICATE.getKey(), IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])IOFunctions.readBytes((File)object3)).toExternalForm());
                properties.put(ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey(), IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])IOFunctions.readBytes((File)object2)).toExternalForm());
                ++n;
            }
        }
        progressUpdater.updateProgress(30);
        object3 = com.inet.webserver.structure.a.t();
        object2 = com.inet.webserver.structure.a.u();
        if (((com.inet.webserver.structure.a)object3).x() && ((com.inet.webserver.structure.a)object2).x()) {
            properties.put(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey(), Objects.requireNonNull(((com.inet.webserver.structure.a)object3).w()).toExternalForm());
            properties.put(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey(), Objects.requireNonNull(((com.inet.webserver.structure.a)object2).w()).toExternalForm());
            ++n;
        }
        progressUpdater.updateProgress(60);
        URL uRL = b.q();
        URL uRL2 = b.r();
        if (uRL != null && uRL2 != null) {
            object = uRL.openStream();
            try {
                properties.put("acme." + ConfigKey.LISTENER_SSL_CERTIFICATE.getKey(), IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])IOFunctions.readBytes((InputStream)object)).toExternalForm());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            object = uRL2.openStream();
            try {
                properties.put("acme." + ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey(), IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])IOFunctions.readBytes((InputStream)object)).toExternalForm());
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            ++n;
        }
        progressUpdater.updateProgress(90);
        try {
            object = Encryption.encodePassword((String)"backup.certificates.properties");
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("backup.certificates.properties");
            PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(((String)object).toCharArray(), ((String)object).getBytes());
            try (OutputStream outputStream = persistenceEntry2.getOutputStream();){
                properties.store(outputStream, null);
            }
            outputStream = new FileOutputStream(taskPath.resolve("certificates.enc").toFile());
            try {
                IOFunctions.copyData((InputStream)persistenceEntry.getInputStream(), (OutputStream)outputStream);
            }
            finally {
                ((FileOutputStream)outputStream).close();
            }
            outputStream = new FileOutputStream(taskPath.resolve("certificates.key").toFile());
            try {
                ((FileOutputStream)outputStream).write(Encryption.encodePassword((String)object).getBytes());
            }
            finally {
                ((FileOutputStream)outputStream).close();
            }
            persistenceEntry.deleteValue();
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        contentInformation.addTaskDetails(this.getKey(), MSG.getMsg("job.taskdetail", new Object[]{n}));
        progressUpdater.updateProgress(100);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT"}, justification="Files accessed by URL are file:// or data: urls are well known and configured by administrative users.")
    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        progressUpdater.updateProgress(0);
        Properties properties = new Properties();
        try {
            string = null;
            object5 = new FileInputStream(taskPath.resolve("certificates.key").toFile());
            try {
                string = Encryption.decodePassword((String)IOFunctions.readAsciiString((InputStream)object5));
            }
            finally {
                ((FileInputStream)object5).close();
            }
            object5 = Persistence.getRecoveryEnabledInstance().resolve("backup.certificates.properties");
            object4 = object5.getCryptoInstance(string.toCharArray(), string.getBytes());
            object3 = new FileInputStream(taskPath.resolve("certificates.enc").toFile());
            try {
                IOFunctions.copyData((InputStream)object3, (OutputStream)object5.getOutputStream());
            }
            finally {
                ((FileInputStream)object3).close();
            }
            object3 = object4.getInputStream();
            try {
                if (object3 == null) {
                    throw new IllegalStateException();
                }
                properties.load((InputStream)object3);
            }
            finally {
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
            }
            object5.deleteValue();
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            ErrorCode.throwAny((Throwable)runtimeException);
        }
        progressUpdater.updateProgress(10);
        string = properties.getProperty(ConfigKey.LISTENER_SSL_CERTIFICATE.getKey());
        object5 = properties.getProperty(ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey());
        if (!StringFunctions.isEmpty((String)string) && !StringFunctions.isEmpty((String)object5)) {
            try {
                object4 = (String)ConfigKey.LISTENER_SSL_CERTIFICATE.getCurrent();
                object3 = com.inet.webserver.structure.b.d(new ConfigStructureSettings(ConfigurationManager.getInstance().getCurrent(), Locale.GERMAN, new Properties()));
                if (StringFunctions.isEmpty((String)object4)) {
                    new File((String)object3).mkdirs();
                    object4 = new File((String)object3, "certificate.crt").getAbsolutePath();
                    ConfigurationManager.getInstance().getCurrent().put(ConfigKey.LISTENER_SSL_CERTIFICATE, (String)object4);
                }
                IOFunctions.copyData((InputStream)new URL(string).openStream(), (OutputStream)new FileOutputStream((String)object4));
                object2 = (String)ConfigKey.LISTENER_SSL_PRIVATEKEY.getCurrent();
                if (StringFunctions.isEmpty((String)object2)) {
                    new File((String)object3).mkdirs();
                    object2 = new File((String)object3, "certificate.key").getAbsolutePath();
                    ConfigurationManager.getInstance().getCurrent().put(ConfigKey.LISTENER_SSL_PRIVATEKEY, (String)object2);
                }
                IOFunctions.copyData((InputStream)new URL((String)object5).openStream(), (OutputStream)new FileOutputStream((String)object2));
            }
            catch (Throwable throwable) {
                ErrorCode.throwAny((Throwable)throwable);
            }
        }
        progressUpdater.updateProgress(40);
        object4 = properties.getProperty(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey());
        object3 = properties.getProperty(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey());
        if (!StringFunctions.isEmpty((String)object4) && !StringFunctions.isEmpty((String)object3)) {
            object2 = IOFunctions.readBytes((InputStream)new URL((String)object4).openStream());
            object = IOFunctions.readBytes((InputStream)new URL((String)object3).openStream());
            com.inet.webserver.structure.a.t().a((byte[])object2);
            com.inet.webserver.structure.a.u().a((byte[])object);
        }
        progressUpdater.updateProgress(70);
        object2 = properties.getProperty("acme." + ConfigKey.LISTENER_SSL_CERTIFICATE.getKey());
        object = properties.getProperty("acme." + ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey());
        if (!StringFunctions.isEmpty((String)object2) && !StringFunctions.isEmpty((String)object)) {
            byte[] byArray = IOFunctions.readBytes((InputStream)new URL((String)object2).openStream());
            byte[] byArray2 = IOFunctions.readBytes((InputStream)new URL((String)object).openStream());
            b.a(byArray, byArray2);
        }
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return true;
    }
}

