/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.toolbox;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.IDN;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.shredzone.acme4j.exception.AcmeProtocolException;

public final class AcmeUtils {
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final String ACME_ERROR_PREFIX = "urn:ietf:params:acme:error:";
    private static final Pattern DATE_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(?:\\.(\\d{1,3})\\d*)?(Z|[+-]\\d{2}:?\\d{2})$", 2);
    private static final Pattern TZ_PATTERN = Pattern.compile("([+-])(\\d{2}):?(\\d{2})$");
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("([^;]+)(?:;.*?charset=(\"?)([a-z0-9_-]+)(\\2))?.*", 2);
    private static final Pattern MAIL_PATTERN = Pattern.compile("\\?|@.*,");
    private static final Pattern BASE64URL_PATTERN = Pattern.compile("[0-9A-Za-z_-]*");
    private static final Base64.Encoder PEM_ENCODER = Base64.getMimeEncoder(64, "\n".getBytes(StandardCharsets.US_ASCII));
    private static final Base64.Encoder URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder URL_DECODER = Base64.getUrlDecoder();

    private AcmeUtils() {
    }

    public static byte[] sha256hash(String z) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(z.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AcmeProtocolException("Could not compute hash", ex);
        }
    }

    public static String hexEncode(byte[] data) {
        char[] result = new char[data.length * 2];
        for (int ix = 0; ix < data.length; ++ix) {
            int val = data[ix] & 0xFF;
            result[ix * 2] = HEX[val >>> 4];
            result[ix * 2 + 1] = HEX[val & 0xF];
        }
        return new String(result);
    }

    public static String base64UrlEncode(byte[] data) {
        return URL_ENCODER.encodeToString(data);
    }

    public static byte[] base64UrlDecode(String base64) {
        return URL_DECODER.decode(base64);
    }

    public static boolean isValidBase64Url(@Nullable String base64) {
        return base64 != null && BASE64URL_PATTERN.matcher(base64).matches();
    }

    public static String toAce(String domain) {
        Objects.requireNonNull(domain, "domain");
        return IDN.toASCII(domain.trim()).toLowerCase(Locale.ENGLISH);
    }

    public static Instant parseTimestamp(String str) {
        Matcher m = DATE_PATTERN.matcher(str);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal date: " + str);
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int dom = Integer.parseInt(m.group(3));
        int hour = Integer.parseInt(m.group(4));
        int minute = Integer.parseInt(m.group(5));
        int second = Integer.parseInt(m.group(6));
        StringBuilder msStr = new StringBuilder();
        if (m.group(7) != null) {
            msStr.append(m.group(7));
        }
        while (msStr.length() < 3) {
            msStr.append('0');
        }
        int ms = Integer.parseInt(msStr.toString());
        String tz = m.group(8);
        tz = "Z".equalsIgnoreCase(tz) ? "GMT" : TZ_PATTERN.matcher(tz).replaceAll("GMT$1$2:$3");
        return ZonedDateTime.of(year, month, dom, hour, minute, second, ms * 1000000, ZoneId.of(tz)).toInstant();
    }

    public static String localeToLanguageHeader(@Nullable Locale locale) {
        if (locale == null || "und".equals(locale.toLanguageTag())) {
            return "*";
        }
        String langTag = locale.toLanguageTag();
        StringBuilder header = new StringBuilder(langTag);
        if (langTag.indexOf(45) >= 0) {
            header.append(',').append(locale.getLanguage()).append(";q=0.8");
        }
        header.append(",*;q=0.1");
        return header.toString();
    }

    @Nullable
    public static String stripErrorPrefix(@Nullable String type) {
        if (type != null && type.startsWith(ACME_ERROR_PREFIX)) {
            return type.substring(ACME_ERROR_PREFIX.length());
        }
        return null;
    }

    public static void writeToPem(byte[] encoded, PemLabel label, Writer out) throws IOException {
        out.append("-----BEGIN ").append(label.toString()).append("-----\n");
        out.append(new String(PEM_ENCODER.encode(encoded), StandardCharsets.US_ASCII));
        out.append("\n-----END ").append(label.toString()).append("-----\n");
    }

    @Nullable
    public static String getContentType(@Nullable String header) {
        Matcher m;
        if (header != null && (m = CONTENT_TYPE_PATTERN.matcher(header)).matches()) {
            String charset = m.group(3);
            if (charset != null && !"utf-8".equalsIgnoreCase(charset)) {
                throw new AcmeProtocolException("Unsupported charset " + charset);
            }
            return m.group(1).trim().toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    public static void validateContact(URI contact) {
        String address;
        if ("mailto".equalsIgnoreCase(contact.getScheme()) && MAIL_PATTERN.matcher(address = contact.toString().substring(7)).find()) {
            throw new IllegalArgumentException("multiple recipients or hfields are not allowed: " + String.valueOf(contact));
        }
    }

    public static String getRenewalUniqueIdentifier(X509Certificate certificate) {
        try {
            X509CertificateHolder cert = new X509CertificateHolder(certificate.getEncoded());
            String aki = Optional.of(cert).map(X509CertificateHolder::getExtensions).map(AuthorityKeyIdentifier::fromExtensions).map(AuthorityKeyIdentifier::getKeyIdentifier).map(AcmeUtils::base64UrlEncode).orElseThrow(() -> new AcmeProtocolException("Missing or invalid Authority Key Identifier"));
            String sn = Optional.of(cert).map(X509CertificateHolder::toASN1Structure).map(Certificate::getSerialNumber).map(AcmeUtils::getRawInteger).map(AcmeUtils::base64UrlEncode).orElseThrow(() -> new AcmeProtocolException("Missing or invalid serial number"));
            return aki + "." + sn;
        }
        catch (Exception ex) {
            throw new AcmeProtocolException("Invalid certificate", ex);
        }
    }

    private static byte[] getRawInteger(ASN1Integer integer) {
        try {
            byte[] encoded = integer.getEncoded();
            return Arrays.copyOfRange(encoded, 2, encoded.length);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static enum PemLabel {
        CERTIFICATE("CERTIFICATE"),
        CERTIFICATE_REQUEST("CERTIFICATE REQUEST"),
        PRIVATE_KEY("PRIVATE KEY"),
        PUBLIC_KEY("PUBLIC KEY");

        private final String label;

        private PemLabel(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

