/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.jcajce.provider.DSAUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvDSAPublicKey
implements DSAPublicKey,
ProvKey<AsymmetricDSAPublicKey> {
    private static final long serialVersionUID = 1752452449903495175L;
    private transient AsymmetricDSAPublicKey baseKey;

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKey dSAPublicKey) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(dSAPublicKey.getParams()), dSAPublicKey.getY());
    }

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKeySpec dSAPublicKeySpec) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(dSAPublicKeySpec), dSAPublicKeySpec.getY());
    }

    ProvDSAPublicKey(AsymmetricDSAPublicKey asymmetricDSAPublicKey) {
        this.baseKey = asymmetricDSAPublicKey;
    }

    @Override
    public AsymmetricDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getY() {
        return this.baseKey.getY();
    }

    @Override
    public DSAParams getParams() {
        if (this.baseKey.getDomainParameters() == null) {
            return null;
        }
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        if (object instanceof ProvDSAPublicKey) {
            ProvDSAPublicKey provDSAPublicKey = (ProvDSAPublicKey)object;
            return this.baseKey.equals(provDSAPublicKey.baseKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
        return Arrays.areEqual(this.getEncoded(), dSAPublicKey.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("DSA", this.baseKey.getY(), this.baseKey.getDomainParameters());
    }
}

