/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.HKDFKeyParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TwoStepKeyGenerator {
    private Mac mac;
    private int macLen;

    public TwoStepKeyGenerator(Mac mac) {
        this.mac = mac;
        this.macLen = mac instanceof HMac ? ((HMac)mac).getUnderlyingDigest().getDigestSize() : ((CMac)mac).getMacSize();
    }

    public KeyParameter generate(HKDFKeyParameters hKDFKeyParameters) {
        return this.extract(hKDFKeyParameters.getSalt(), hKDFKeyParameters.getIKM());
    }

    private KeyParameter extract(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            this.mac.init(new KeyParameterImpl(new byte[this.macLen]));
        } else {
            this.mac.init(new KeyParameterImpl(byArray));
        }
        this.mac.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.macLen];
        this.mac.doFinal(byArray3, 0);
        return new KeyParameterImpl(byArray3);
    }
}

