/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.util.Arrays;

public enum RevocationReason {
    UNSPECIFIED(0),
    KEY_COMPROMISE(1),
    CA_COMPROMISE(2),
    AFFILIATION_CHANGED(3),
    SUPERSEDED(4),
    CESSATION_OF_OPERATION(5),
    CERTIFICATE_HOLD(6),
    REMOVE_FROM_CRL(8),
    PRIVILEGE_WITHDRAWN(9),
    AA_COMPROMISE(10);

    private final int reasonCode;

    private RevocationReason(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public static RevocationReason code(int reasonCode) {
        return Arrays.stream(RevocationReason.values()).filter(rr -> rr.reasonCode == reasonCode).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown revocation reason code: " + reasonCode));
    }
}

