/*
 * Decompiled with CFR 0.152.
 */
package com.inet.webserver.structure;

import com.inet.classloader.BaseLocator;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.TempConfiguration;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.FileUploadConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.ClientMessageException;
import com.inet.http.security.TrustAllTrustManager;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.trigger.FileChangeTriggerBuilder;
import com.inet.taskplanner.server.api.trigger.TimeTriggerBuilder;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.webserver.ListenerSettings;
import com.inet.webserver.SSLSelfSignedCertificateGenerator;
import com.inet.webserver.WebServerPlugin;
import com.inet.webserver.c;
import com.inet.webserver.f;
import com.inet.webserver.structure.WebConfigKeys;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class b
extends AbstractStructureProvider {
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.system": {
                categories.add(new ConfigCategory(200, "category.webserver", this.translate(settings, "category.webserver", new Object[0]), "system-webserver"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.webserver": {
                return ((Object)((Object)this)).getClass().getResource("webserver_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.webserver": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.webserver.connections", this.translate(settings, "group.webserver.connections", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(150, "group.webserver.certificates.fix", null, new ConfigAction("action.webserver.uploaded.certificate", this.translate(settings, "action.webserver.certificate", new Object[0]))));
                propertyGroups.add(new ConfigPropertyGroup(155, "group.webserver.certificates.fix.file", null, new ConfigAction("action.webserver.certificate", this.translate(settings, "action.webserver.certificate", new Object[0]))));
                if (b.f(settings)) {
                    propertyGroups.add(new ConfigPropertyGroup(160, "group.webserver.certificates.letsencrypt", null, new ConfigAction("action.webserver.letsencrypt", this.translate(settings, "action.webserver.letsencrypt", new Object[0]))));
                }
                propertyGroups.add(new ConfigPropertyGroup(170, "action.validate.certificate", null, new ConfigAction("action.validate.certificate", this.translate(settings, "action.validate.certificate", new Object[0]))));
                if (advanced) {
                    propertyGroups.add(new ConfigPropertyGroup(200, "group.webserver.performance", this.translate(settings, "group.webserver.performance", new Object[0])));
                    propertyGroups.add(new ConfigPropertyGroup(400, "group.webserver.security", this.translate(settings, "group.webserver.security", new Object[0])));
                }
                try {
                    Integer.parseInt(Objects.requireNonNullElse(System.getProperty("restart.exitcode"), "NaN"));
                    ConfigAction configAction = new ConfigAction("action.webserver.restart", this.translate(settings, "action.webserver.restart", new Object[0]));
                    propertyGroups.add(new ConfigPropertyGroup(300, "group.webserver.restart", this.translate(settings, "group.webserver.restart", new Object[0]), configAction));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!advanced) break;
                propertyGroups.add(new ConfigPropertyGroup(500, "group.header.http", this.translate(settings, "group.header.http", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(501, "group.header.https", this.translate(settings, "group.header.https", new Object[0])));
                break;
            }
            case "action.webserver.certificate": {
                propertyGroups.add(new ConfigPropertyGroup(100, "action.webserver.certificate"));
                break;
            }
            case "action.webserver.uploaded.certificate": {
                propertyGroups.add(new ConfigPropertyGroup(100, "action.webserver.uploaded.certificate"));
                break;
            }
            case "action.webserver.letsencrypt": {
                propertyGroups.add(new ConfigPropertyGroup(100, "action.webserver.letsencrypt"));
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        switch (categoryKey) {
            case "category.webserver": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.LISTENER_CONNECTION_TYPE).equals().value((Object)"plain_and_secure");
                ConfigCondition configCondition2 = conditionGenerator.createCondition().property(ConfigKey.LISTENER_CONNECTION_TYPE).equals().value((Object)"plain");
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(ConfigKey.LISTENER_CONNECTION_TYPE).equals().value((Object)"secure");
                configCondition2 = conditionGenerator.createCondition().or(new ConfigCondition[]{configCondition2, configCondition});
                configCondition3 = conditionGenerator.createCondition().or(new ConfigCondition[]{configCondition3, configCondition});
                ConfigCondition configCondition4 = conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition3, conditionGenerator.createCondition().property(WebConfigKeys.CERTIFICATE_TYPE).equals().value((Object)"fix")});
                ConfigCondition configCondition5 = conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition3, conditionGenerator.createCondition().property(WebConfigKeys.CERTIFICATE_TYPE).equals().value((Object)"fix.upload")});
                ConfigCondition configCondition6 = conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition3, conditionGenerator.createCondition().property(WebConfigKeys.CERTIFICATE_TYPE).equals().value((Object)"letsencrypt")});
                if (b.f(settings) && advanced) {
                    ConfigCondition configCondition7 = conditionGenerator.createCondition().property(WebConfigKeys.CERTIFICATE_TYPE).equals().value((Object)"letsencrypt");
                    ConfigCondition configCondition8 = conditionGenerator.createCondition().not(configCondition7);
                    ConfigCondition configCondition9 = conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(WebConfigKeys.LISTENER_CONTEXT).equals().value((Object)"/"));
                    ConfigCondition configCondition10 = conditionGenerator.createCondition().property(ConfigKey.LISTENER_CONNECTION_TYPE).equals().value((Object)"plain");
                    actions.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().or(new ConfigCondition[]{configCondition8, configCondition9, configCondition10}), WebConfigKeys.LISTENER_CONTEXT));
                }
                actions.add(conditionGenerator.visibleActionFor(configCondition6, "group.webserver.certificates.letsencrypt"));
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.LISTENER_SSL_REDIRECT));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.LISTENER_PORT));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, ConfigKey.LISTENER_SSL_PORT));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, WebConfigKeys.CERTIFICATE_TYPE));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, "group.webserver.certificates.fix.file"));
                actions.add(conditionGenerator.visibleActionFor(configCondition5, "group.webserver.certificates.fix"));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, "action.validate.certificate"));
                if (!advanced) break;
                actions.add(conditionGenerator.visibleActionFor(configCondition2, "group.header.http"));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, ConfigKey.HTTP_HEADER_FIELDS));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, "group.header.https"));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, ConfigKey.HTTPS_HEADER_FIELDS));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.webserver.connections": {
                String string;
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("plain", this.translate(settings, "plain", new Object[0])));
                arrayList.add(new LocalizedKey("plain_and_secure", this.translate(settings, "plain_and_secure", new Object[0])));
                arrayList.add(new LocalizedKey("secure", this.translate(settings, "secure", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.LISTENER_CONNECTION_TYPE, settings, arrayList);
                if (advanced) {
                    this.addTo(configProperties, ConfigKey.LISTENER_BIND_ADDRESS, "SimpleText", settings, this.translate(settings, ConfigKey.LISTENER_BIND_ADDRESS.getKey() + ".placeholder", new Object[0]));
                    this.addTo(configProperties, WebConfigKeys.LISTENER_CONTEXT, "SimpleText", settings, this.translate(settings, WebConfigKeys.LISTENER_CONTEXT.getKey() + ".placeholder", new Object[0]));
                }
                if (StringFunctions.isEmpty((String)(string = settings.getChangedValue(ConfigKey.LISTENER_PORT.getKey())))) {
                    string = String.valueOf(ListenerSettings.getPlainPort(settings.getConfiguration()));
                }
                this.addTo(configProperties, ConfigKey.LISTENER_PORT.getKey(), "FixNumber", string, settings);
                string = settings.getChangedValue(ConfigKey.LISTENER_SSL_PORT.getKey());
                if (StringFunctions.isEmpty((String)string)) {
                    string = String.valueOf(ListenerSettings.getSslPort(settings.getConfiguration()));
                }
                this.addTo(configProperties, ConfigKey.LISTENER_SSL_PORT.getKey(), "FixNumber", string, settings);
                String string2 = settings.getValue(ConfigKey.LISTENER_SSL_REDIRECT);
                this.addTo(configProperties, ConfigKey.LISTENER_SSL_REDIRECT.getKey(), "Boolean", string2, settings);
                if (advanced) {
                    this.addTo(configProperties, ConfigKey.SERVER_URL.getKey(), "SimpleText", settings.getConfiguration().get(ConfigKey.SERVER_URL.getKey()), settings, ConfigKey.SERVER_URL.getDefault());
                }
                ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
                arrayList2.add(new LocalizedKey("fix.upload", this.translate(settings, "fix.upload", new Object[0])));
                arrayList2.add(new LocalizedKey("fix", this.translate(settings, "fix", new Object[0])));
                if (b.f(settings)) {
                    arrayList2.add(new LocalizedKey("letsencrypt", this.translate(settings, "letsencrypt", new Object[0])));
                }
                this.addSelectTo(configProperties, WebConfigKeys.CERTIFICATE_TYPE, settings, arrayList2);
                break;
            }
            case "group.webserver.certificates.fix.file": {
                this.addTo(configProperties, ConfigKey.LISTENER_SSL_CERTIFICATE, "File", settings);
                this.addTo(configProperties, ConfigKey.LISTENER_SSL_PRIVATEKEY, "File", settings);
                this.a(configProperties, settings);
                break;
            }
            case "group.webserver.certificates.fix": {
                String string = settings.getChangedValue(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey());
                String string3 = settings.getChangedValue(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey());
                byte[] byArray = null;
                if (string == null || string3 == null || !string.startsWith("data:application/ssl-certificate-reader") || !string3.startsWith("data:application/ssl-certificate-reader")) {
                    string = ((Serializable)((Object)Objects.requireNonNullElse(com.inet.webserver.structure.a.t().w(), ""))).toString();
                    string3 = ((Serializable)((Object)Objects.requireNonNullElse(com.inet.webserver.structure.a.u().w(), ""))).toString();
                }
                this.addFileUploadTo(configProperties, WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey(), settings, "*", string);
                this.addFileUploadTo(configProperties, WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey(), settings, "*", string3);
                int n = 0;
                n += com.inet.webserver.structure.a.t().x() ? 1 : 0;
                n += com.inet.webserver.structure.a.u().x() ? 2 : 0;
                try {
                    byArray = FileUploadConfigProperty.decodeUploadDataAsBytes((String)string);
                    Set<String> set = this.b(byArray);
                    this.addTo(configProperties, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".status", "KeyLabel", String.join((CharSequence)"; ", set), settings);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addTo(configProperties, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".status", "KeyLabel", WebServerPlugin.MSG.getMsg("listener.ssl.status.upload", new Object[]{n}), settings);
                break;
            }
            case "group.webserver.certificates.letsencrypt": {
                String string = settings.getValue(WebConfigKeys.CERTIFICATE_DOMAINS);
                if (string == null || string.length() == 0) {
                    string = this.translate(settings, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".placeholder", new Object[0]);
                }
                this.addTo(configProperties, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".status", "KeyLabel", string, settings);
                this.addTo(configProperties, WebConfigKeys.CERTIFICATE_DOMAINS, "Hidden", settings);
                break;
            }
            case "group.webserver.performance": {
                this.addTo(configProperties, ConfigKey.MAX_CONCURRENT_REQUESTS, settings);
                this.addTo(configProperties, ConfigKey.MAX_HTTP_REQUESTS, settings);
                if (!Persistence.isFilePersistence()) break;
                try {
                    if (!ConfigurationManager.isRecoveryMode()) {
                        Integer.parseInt(Objects.requireNonNullElse(System.getProperty("restart.exitcode"), "NaN"));
                    }
                    this.addUnitTo(configProperties, WebConfigKeys.MAX_HEAP_MEMORY, settings, Arrays.asList(new UnitConfigProperty.Unit(1.0, "MB"), new UnitConfigProperty.Unit(9.765625E-4, "GB")), this.translate(settings, WebConfigKeys.MAX_HEAP_MEMORY.getKey() + ".placeholder", new Object[]{Runtime.getRuntime().maxMemory() / 1024L / 1024L}));
                    this.addTo(configProperties, WebConfigKeys.USER_LANGUAGE, settings, Locale.getDefault().getLanguage());
                    this.addTo(configProperties, WebConfigKeys.USER_COUNTRY, settings, Locale.getDefault().getCountry());
                    this.addTo(configProperties, WebConfigKeys.VM_ARGUMENTS, settings, "");
                }
                catch (Throwable throwable) {}
                break;
            }
            case "group.webserver.restart": {
                this.addTo(configProperties, "webserver.restart.hint", "Label", settings);
                break;
            }
            case "group.webserver.security": {
                this.addTo(configProperties, "cookie.sameSite.hint", "Label", settings);
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("None", this.translate(settings, "cookie.sameSite.None", new Object[0])));
                arrayList.add(new LocalizedKey("Lax", this.translate(settings, "cookie.sameSite.Lax", new Object[0])));
                arrayList.add(new LocalizedKey("Strict", this.translate(settings, "cookie.sameSite.Strict", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.COOKIE_SAME_SITE, settings, arrayList);
                ArrayList<LocalizedKey> arrayList3 = new ArrayList<LocalizedKey>();
                arrayList3.add(new LocalizedKey("None", this.translate(settings, "listener.frameembedding.None", new Object[0])));
                arrayList3.add(new LocalizedKey("SameOrigin", this.translate(settings, "listener.frameembedding.SameOrigin", new Object[0])));
                arrayList3.add(new LocalizedKey("Deny", this.translate(settings, "listener.frameembedding.Deny", new Object[0])));
                this.addSelectTo(configProperties, ConfigKey.ALLOW_FRAME_EMBEDDING, settings, arrayList3);
                this.addTo(configProperties, WebConfigKeys.ALLOW_ORIGIN, "SimpleText", settings);
                this.addTo(configProperties, ConfigKey.CROSSDOMAIN_XML, "MultiLineText", settings);
                this.addTo(configProperties, ConfigKey.ROBOTS_TXT, "MultiLineText", settings);
                this.addTo(configProperties, ConfigKey.SECURITY_TXT, "MultiLineText", settings);
                break;
            }
            case "action.webserver.certificate": 
            case "action.webserver.uploaded.certificate": {
                this.addTo(configProperties, "hostname", "SimpleText", b.a(settings), settings);
                this.addTo(configProperties, "organization", "SimpleText", b.b(settings), settings);
                this.addTo(configProperties, "location", "SimpleText", "", settings);
                this.addTo(configProperties, "countryCode", "SimpleText", b.c(settings), settings);
                if (!"action.webserver.certificate".equals(propertyGroupKey)) break;
                this.addTo(configProperties, "targetFolder", "Directory", b.d(settings), settings);
                break;
            }
            case "action.webserver.letsencrypt": {
                String string = settings.getValue("acme.domain");
                if (string == null || string.trim().isEmpty()) {
                    string = settings.getValue(WebConfigKeys.CERTIFICATE_DOMAINS);
                }
                configProperties.add(new ConfigProperty(50, "acme.domain", "MultiLineText", this.translate(settings, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".status", new Object[0]), (Object)string, null, this.translate(settings, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".placeholder", new Object[0])));
                configProperties.add(new ConfigProperty(100, "acme.agreement.link", "Link", this.translate(settings, "acme.agreement", new Object[0]), (Object)new com.inet.webserver.acme.b().o(), null, null));
                configProperties.add((ConfigProperty)new BooleanConfigProperty(200, "acme.agreement", this.translate(settings, "acme.agreement.accept", new Object[0]), null, null, (Object)"false"));
                break;
            }
            case "group.header.http": 
            case "group.header.https": {
                Comparator comparator = (stringArray, stringArray2) -> {
                    String string = stringArray[0];
                    String string2 = stringArray2[0];
                    if (string == null) {
                        return string2 == null ? 0 : 1;
                    }
                    if (string2 == null) {
                        return -1;
                    }
                    return string.compareTo(string2);
                };
                ConfigProperty configProperty = new ConfigProperty(0, "", "SimpleText", this.translate(settings, "group.http.header.key", new Object[0]), null, null, null);
                ConfigProperty configProperty2 = new ConfigProperty(0, "", "SimpleText", this.translate(settings, "group.http.header.value", new Object[0]), null, null, null);
                ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, "group.http.header.add", new Object[0]))};
                int[] nArray = new int[]{33, 67};
                ConfigKey configKey = "group.header.http".equals(propertyGroupKey) ? ConfigKey.HTTP_HEADER_FIELDS : ConfigKey.HTTPS_HEADER_FIELDS;
                List<String[]> list = b.a(configKey, settings);
                Collections.sort(list, comparator);
                this.addTableTo(configProperties, configKey.getKey(), "", settings, list, configActionArray, nArray, new ConfigProperty[]{configProperty, configProperty2});
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The path is provided by an adminstrative user.")
    private void a(Set<ConfigProperty> set, ConfigStructureSettings configStructureSettings) {
        Object object;
        String string = configStructureSettings.getValue(ConfigKey.LISTENER_SSL_CERTIFICATE);
        Set<Object> set2 = Set.of();
        if (!StringFunctions.isEmpty((String)string) && new File(string).isFile()) {
            try {
                object = IOFunctions.readBytes((File)new File(string));
                set2 = this.b((byte[])object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object = String.join((CharSequence)"; ", set2);
        if (set2.isEmpty()) {
            object = this.translate(configStructureSettings, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".placeholder", new Object[0]);
        }
        this.addTo(set, WebConfigKeys.CERTIFICATE_DOMAINS.getKey() + ".status", "KeyLabel", (String)object, configStructureSettings);
    }

    private Set<String> b(byte @Nullable [] byArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (byArray == null) {
            return hashSet;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            String string = x509Certificate.getSubjectX500Principal().getName();
            int n = string.indexOf("CN=");
            if (n >= 0) {
                string = string.substring(n + 3);
            }
            if ((n = string.indexOf(44)) >= 0) {
                string = string.substring(0, n);
            }
            hashSet.add(string);
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                for (List<?> list : collection) {
                    String string2 = list.get(1).toString();
                    hashSet.add(string2);
                }
            }
        }
        catch (Throwable throwable) {
            hashSet.add(throwable.getLocalizedMessage());
        }
        return hashSet;
    }

    @Nonnull
    @SuppressFBWarnings(value={"SERVLET_SERVER_NAME"}, justification="server name only used for user data")
    private static String a(@Nonnull ConfigStructureSettings configStructureSettings) throws IllegalStateException {
        String string = configStructureSettings.getValue("hostname");
        if (string == null) {
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest == null) {
                throw new IllegalStateException();
            }
            string = httpServletRequest.getServerName();
            if (string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1") || string.equals("::1")) {
                InetAddress[] inetAddressArray;
                for (InetAddress inetAddress : inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses()) {
                    String string2 = inetAddress.getHostName();
                    if (string2.length() <= 0 || !Character.isLetter(string2.charAt(0))) continue;
                    string = string2;
                    break;
                }
            }
        }
        return string;
    }

    @Nonnull
    private static String b(@Nonnull ConfigStructureSettings configStructureSettings) {
        String string = configStructureSettings.getValue("organization");
        if (string == null) {
            string = configStructureSettings.getLicense().getLicensee();
            if (string == null) {
                string = "";
            } else {
                int n = string.indexOf(10);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                string = string.trim();
            }
        }
        return string;
    }

    @Nonnull
    private static String c(@Nonnull ConfigStructureSettings configStructureSettings) {
        String string = configStructureSettings.getValue("countryCode");
        if (string == null) {
            string = Locale.getDefault().getCountry();
        }
        return string;
    }

    @Nonnull
    public static String d(@Nonnull ConfigStructureSettings configStructureSettings) {
        String string = configStructureSettings.getValue("targetFolder");
        if (string == null) {
            string = Persistence.isFilePersistence() ? ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().resolve(".ssh").toString() : BaseLocator.getBaseDirectory().getPath();
        }
        return string;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only admin set the directory")
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object object;
        if (categoryKey == null || categoryKey.equals("category.webserver")) {
            String string;
            object = null;
            boolean bl = false;
            try {
                if (!ConfigurationManager.isRecoveryMode()) {
                    object = new URL(settings.getValue(ConfigKey.SERVER_URL));
                    bl = PrivateCloudLicenseTimerTask.isKnown((URL)object);
                    PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object);
                }
            }
            catch (Throwable throwable) {
                object = null;
                bl = false;
            }
            ConfigValidator configValidator = new ConfigValidator(messages, settings);
            Object object2 = null;
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest != null) {
                int n = httpServletRequest.getLocalPort();
                object2 = n == ListenerSettings.getPlainPort(settings.getConfiguration()) ? ConfigKey.LISTENER_PORT : (n == ListenerSettings.getSslPort(settings.getConfiguration()) ? ConfigKey.LISTENER_SSL_PORT : null);
            }
            configValidator.checkNeedRestart(ConfigKey.LISTENER_CONNECTION_TYPE);
            configValidator.checkNeedRestart(ConfigKey.LISTENER_BIND_ADDRESS);
            configValidator.checkNeedRestart(WebConfigKeys.LISTENER_CONTEXT);
            String string2 = settings.getValue(WebConfigKeys.LISTENER_CONTEXT);
            if (StringFunctions.isEmpty((String)string2) || !string2.startsWith("/") || string2.length() > 1 && string2.endsWith("/")) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "error.validator.context", new Object[0]), WebConfigKeys.LISTENER_CONTEXT));
            }
            if (settings.getChangedValue(WebConfigKeys.LISTENER_CONTEXT.getKey()) != null) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "listener.context.change", new Object[0]), WebConfigKeys.LISTENER_CONTEXT.getKey()));
            }
            switch (string = settings.getValue(ConfigKey.LISTENER_CONNECTION_TYPE)) {
                case "plain": 
                case "plain_and_secure": {
                    this.a(false, (ConfigKey)object2, messages, settings, configValidator);
                    break;
                }
            }
            switch (string) {
                case "plain_and_secure": 
                case "secure": {
                    this.a(true, (ConfigKey)object2, messages, settings, configValidator);
                    this.a(messages, settings, false);
                    break;
                }
            }
            configValidator.validateHttpURL(ConfigKey.SERVER_URL);
            configValidator.validateNumberRange(ConfigKey.MAX_CONCURRENT_REQUESTS, 5L, 10000L);
            configValidator.validateNumberRange(ConfigKey.MAX_HTTP_REQUESTS, 3L, 1000L);
            String string3 = settings.getValue(WebConfigKeys.MAX_HEAP_MEMORY);
            if (string3 != null && !string3.isEmpty()) {
                configValidator.validateUnitNumberRangeWholeNumbers(WebConfigKeys.MAX_HEAP_MEMORY, 128L, Long.MAX_VALUE, "MB");
            }
            configValidator.checkNeedRestart(WebConfigKeys.MAX_HEAP_MEMORY);
            String string4 = settings.getValue(WebConfigKeys.USER_COUNTRY);
            if (!StringFunctions.isEmpty((String)string4)) {
                try {
                    Currency.getInstance(new Locale("", string4));
                }
                catch (Exception exception) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "error.validator.country", new Object[]{string4}), WebConfigKeys.USER_COUNTRY));
                }
            }
            configValidator.checkNeedRestart(WebConfigKeys.USER_LANGUAGE);
            configValidator.checkNeedRestart(WebConfigKeys.USER_COUNTRY);
            this.a(ConfigKey.HTTP_HEADER_FIELDS, messages, settings, configValidator);
            this.a(ConfigKey.HTTPS_HEADER_FIELDS, messages, settings, configValidator);
            configValidator.checkNeedRestart(ConfigKey.COOKIE_SAME_SITE);
            if (object != null && messages.size() == 0 && !ConfigurationManager.isRecoveryMode()) {
                String string5;
                if (!bl) {
                    for (int i = 0; i < 20 && PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object) != null; ++i) {
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
                if ((string5 = PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object)) != null) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Warning, string5, ConfigKey.SERVER_URL));
                }
            }
        }
        if ("action.webserver.certificate".equals(categoryKey)) {
            object = new ConfigValidator(messages, settings);
            String string = b.d(settings);
            new File(string).mkdirs();
            object.checkDirectoryExists("targetFolder", string);
        }
        if ("action.webserver.letsencrypt".equals(categoryKey)) {
            if (!Boolean.parseBoolean(settings.getValue("acme.agreement"))) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "action.webserver.letsencrypt.aggreement.accept", new Object[0]), "acme.agreement"));
            }
            if ((object = settings.getValue("acme.domain")) == null || ((String)object).trim().isEmpty()) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "action.webserver.letsencrypt.nodomain", new Object[0]), "acme.domain"));
                return;
            }
            String[] stringArray = ((String)object).split("\\s");
            if (!this.a(stringArray, messages, settings)) {
                return;
            }
            try {
                new com.inet.webserver.acme.b().a(stringArray, true);
                this.e(settings);
                a.y();
            }
            catch (Exception exception) {
                c.o.debug((Object)exception);
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "action.webserver.letsencrypt.error", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)exception)}), "acme.domain"));
            }
        }
    }

    private void a(ConfigKey configKey, ArrayList<ConfigValidationMsg> arrayList, ConfigStructureSettings configStructureSettings, ConfigValidator configValidator) {
        List<String[]> list = b.a(configKey, configStructureSettings);
        for (String[] stringArray : list) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.length() <= 0) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "group.http.header.key.empty", new Object[0]), configKey));
                return;
            }
            if (string.contains(":") || string.contains("\n")) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "group.http.header.key.colonNewLine", new Object[0]), configKey));
                return;
            }
            if (!string.trim().equals(string)) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "group.http.header.key.whitespace", new Object[0]), configKey));
                return;
            }
            if (string2.contains("\r") || string2.contains("\n")) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "group.http.header.value.newLine", new Object[0]), configKey));
                return;
            }
            char[] cArray = (string + string2).toCharArray();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < cArray.length; ++i) {
                char c2 = cArray[i];
                if (c2 >= ' ' && c2 <= '\u007f') continue;
                stringBuilder.append(c2);
            }
            if (stringBuilder.length() <= 0) continue;
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "group.http.header.allowedCharsRange", new Object[]{stringBuilder.toString()}), configKey));
            return;
        }
    }

    protected static List<String[]> a(ConfigKey configKey, ConfigStructureSettings configStructureSettings) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList arrayList2 = null;
        try {
            arrayList2 = (ArrayList)configStructureSettings.getChangedValue(configKey, ArrayList.class);
        }
        catch (JsonException jsonException) {
            arrayList.clear();
        }
        if (arrayList2 == null) {
            try {
                Map map = (Map)new Json().fromJson(configStructureSettings.getValue(configKey), HashMap.class);
                if (map != null) {
                    map.forEach((string, string2) -> {
                        String[] stringArray = new String[]{string, string2};
                        arrayList.add(stringArray);
                    });
                }
            }
            catch (JsonException jsonException) {
                arrayList.clear();
            }
        } else {
            for (ArrayList arrayList3 : arrayList2) {
                String[] stringArray = new String[]{(String)arrayList3.get(0), (String)arrayList3.get(1)};
                arrayList.add(stringArray);
            }
        }
        return arrayList;
    }

    private void a(boolean bl, ConfigKey configKey, ArrayList<ConfigValidationMsg> arrayList, ConfigStructureSettings configStructureSettings, ConfigValidator configValidator) {
        ConfigKey configKey2 = bl ? ConfigKey.LISTENER_SSL_PORT : ConfigKey.LISTENER_PORT;
        String string = configStructureSettings.getValue(configKey2);
        String string2 = String.valueOf(ListenerSettings.getPort(bl, configStructureSettings.getConfiguration()));
        if (string.isEmpty()) {
            TempConfiguration tempConfiguration = new TempConfiguration("");
            if (bl) {
                tempConfiguration.put(ConfigKey.LISTENER_PORT, configStructureSettings.getConfiguration().get(ConfigKey.LISTENER_PORT));
            }
            string = String.valueOf(ListenerSettings.getPort(bl, (Configuration)tempConfiguration));
        } else {
            configValidator.validateNumberRange(configKey2.getKey(), string, 1L, 65535L);
        }
        int n = arrayList.size();
        configValidator.checkNeedRestart(configKey2, string, string2);
        if (configKey == configKey2 && n != arrayList.size()) {
            arrayList.add(n, new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(configStructureSettings, "listener.portchange", new Object[0]), configKey2));
        }
    }

    private void a(@Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings, boolean bl) {
        Certificate certificate = this.b(arrayList, configStructureSettings, bl);
        RSAPrivateKey rSAPrivateKey = this.a(arrayList, configStructureSettings);
        if (certificate == null || rSAPrivateKey == null) {
            return;
        }
        try {
            f.a(certificate, rSAPrivateKey);
        }
        catch (Exception exception) {
            ConfigValidationMsg.Type type = ConfigValidationMsg.Type.Invalid;
            if (exception instanceof ClientMessageException) {
                type = ConfigValidationMsg.Type.Warning;
            }
            arrayList.add(new ConfigValidationMsg(type, StringFunctions.getUserFriendlyErrorMessage((Throwable)exception), ConfigKey.LISTENER_SSL_PRIVATEKEY));
        }
    }

    @Nullable
    private Certificate b(@Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings, boolean bl) {
        ConfigValidator configValidator = new ConfigValidator(arrayList, configStructureSettings);
        String string = configStructureSettings.getValue(WebConfigKeys.CERTIFICATE_TYPE);
        ConfigKey configKey = null;
        try {
            URL uRL;
            switch (string) {
                case "fix": {
                    if (!configValidator.checkNotEmpty(ConfigKey.LISTENER_SSL_CERTIFICATE)) {
                        return null;
                    }
                    if (!configValidator.checkFileExists(ConfigKey.LISTENER_SSL_CERTIFICATE)) {
                        return null;
                    }
                    uRL = IOFunctions.getFileURL((String)configStructureSettings.getValue(ConfigKey.LISTENER_SSL_CERTIFICATE));
                    configKey = ConfigKey.LISTENER_SSL_CERTIFICATE;
                    break;
                }
                case "fix.upload": {
                    String string2 = configStructureSettings.getChangedValue(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey());
                    if (StringFunctions.isEmpty((String)string2)) {
                        string2 = ((Serializable)((Object)Objects.requireNonNullElse(com.inet.webserver.structure.a.t().w(), ""))).toString();
                    }
                    byte[] byArray = FileUploadConfigProperty.decodeUploadDataAsBytes((String)string2);
                    uRL = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])byArray);
                    configKey = WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD;
                    break;
                }
                case "letsencrypt": {
                    uRL = com.inet.webserver.acme.b.q();
                    configKey = WebConfigKeys.CERTIFICATE_DOMAINS;
                    if (uRL != null) break;
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.certificate.noLetsencrypt", new Object[]{""}), configKey));
                    return null;
                }
                default: {
                    return null;
                }
            }
            try {
                Object object = f.a(uRL, bl, arrayList);
                if (object == null) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.certificate.notAValidCertificate", new Object[]{""}), configKey));
                }
                return object;
            }
            catch (CertificateException certificateException) {
                ConfigValidationMsg configValidationMsg = b.a(certificateException, configStructureSettings.getLocale(), configKey);
                arrayList.add(configValidationMsg);
            }
        }
        catch (Throwable throwable) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.certificate.notAValidCertificate", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}), configKey));
        }
        return null;
    }

    @Nonnull
    public static ConfigValidationMsg a(@Nonnull Exception exception, @Nonnull Locale locale, @Nonnull ConfigKey configKey) {
        String string = StringFunctions.getUserFriendlyErrorMessage((Throwable)exception);
        ConfigValidationMsg.Type type = ConfigValidationMsg.Type.Invalid;
        block6: for (Throwable throwable = exception; throwable != null && throwable.getMessage() != null; throwable = throwable.getCause()) {
            String string2 = throwable.getMessage();
            if (string2 == null) continue;
            switch (string2) {
                case "unable to find valid certification path to requested target": {
                    string = WebServerPlugin.MSG.getMsg("error.validator.certificate.noTrust", new Object[0]);
                    type = ConfigValidationMsg.Type.Warning;
                    break block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return new ConfigValidationMsg(type, string, configKey);
    }

    @Nullable
    private RSAPrivateKey a(@Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings) {
        ConfigValidator configValidator = new ConfigValidator(arrayList, configStructureSettings);
        String string = configStructureSettings.getValue(WebConfigKeys.CERTIFICATE_TYPE);
        ConfigKey configKey = null;
        try {
            URL uRL;
            switch (string) {
                case "fix": {
                    if (!configValidator.checkNotEmpty(ConfigKey.LISTENER_SSL_PRIVATEKEY)) {
                        return null;
                    }
                    if (!configValidator.checkFileExists(ConfigKey.LISTENER_SSL_PRIVATEKEY)) {
                        return null;
                    }
                    uRL = IOFunctions.getFileURL((String)configStructureSettings.getValue(ConfigKey.LISTENER_SSL_PRIVATEKEY));
                    configKey = ConfigKey.LISTENER_SSL_PRIVATEKEY;
                    break;
                }
                case "fix.upload": {
                    String string2 = configStructureSettings.getChangedValue(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey());
                    if (StringFunctions.isEmpty((String)string2)) {
                        string2 = ((Serializable)((Object)Objects.requireNonNullElse(com.inet.webserver.structure.a.u().w(), ""))).toString();
                    }
                    byte[] byArray = FileUploadConfigProperty.decodeUploadDataAsBytes((String)string2);
                    uRL = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])byArray);
                    configKey = WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD;
                    break;
                }
                case "letsencrypt": {
                    uRL = com.inet.webserver.acme.b.r();
                    configKey = WebConfigKeys.CERTIFICATE_DOMAINS;
                    if (uRL != null) break;
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.privatekey.noLetsencrypt", new Object[]{""}), configKey));
                    return null;
                }
                default: {
                    return null;
                }
            }
            Object object = f.b(uRL);
            if (object == null) {
                if ("data".equals(uRL.getProtocol())) {
                    uRL = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])"<redacted>".getBytes());
                }
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.privatekey.notAValidPrivateKey", new Object[]{uRL}), configKey));
            }
            return object;
        }
        catch (Throwable throwable) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "error.validator.privatekey.notAValidPrivateKey", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}), configKey));
            return null;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="administrator user input is used")
    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        Properties properties = settings.getValues();
        switch (actionKey) {
            case "action.webserver.certificate": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, "", "action.webserver.certificate"));
                break;
            }
            case "action.webserver.uploaded.certificate": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, "", "action.webserver.uploaded.certificate"));
                break;
            }
            case "action.webserver.uploaded.certificate.ok": {
                SSLSelfSignedCertificateGenerator sSLSelfSignedCertificateGenerator = new SSLSelfSignedCertificateGenerator();
                String string = b.a(settings);
                String string2 = b.b(settings);
                String string3 = settings.getValue("location");
                String string4 = b.c(settings);
                try (FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                     FastByteArrayOutputStream fastByteArrayOutputStream2 = new FastByteArrayOutputStream();){
                    sSLSelfSignedCertificateGenerator.createCertificateAndPrivateKey((OutputStream)fastByteArrayOutputStream, (OutputStream)fastByteArrayOutputStream2, string, string2, string3, string4);
                    URL uRL = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])fastByteArrayOutputStream2.toByteArray());
                    URL uRL2 = IOFunctions.getDataUrl((String)"application/ssl-certificate-reader", (byte[])fastByteArrayOutputStream.toByteArray());
                    Objects.requireNonNull(uRL);
                    Objects.requireNonNull(uRL2);
                    Objects.requireNonNull(properties);
                    properties.setProperty(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD.getKey(), uRL.toExternalForm());
                    properties.setProperty(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD.getKey(), uRL2.toExternalForm());
                    break;
                }
                catch (Throwable throwable) {
                    c.o.error(throwable);
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
                }
            }
            case "action.webserver.certificate.ok": {
                SSLSelfSignedCertificateGenerator sSLSelfSignedCertificateGenerator = new SSLSelfSignedCertificateGenerator();
                String string = b.a(settings);
                String string5 = b.b(settings);
                String string6 = settings.getValue("location");
                String string7 = b.c(settings);
                String string8 = b.d(settings);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                if (string5 != null && string5.length() > 0) {
                    stringBuilder.append('_').append(string5);
                }
                if (string6 != null && string6.length() > 0) {
                    stringBuilder.append('_').append(string6);
                }
                if (string7 != null && string7.length() > 0) {
                    stringBuilder.append('_').append(string7);
                }
                String string9 = stringBuilder.toString();
                for (char c2 : " /\\?*:<>|\"".toCharArray()) {
                    string9 = string9.replace(c2, '_');
                }
                Object object = new File(string8, string9 + ".key");
                File file = new File(string8, string9 + ".crt");
                try (FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                     FileOutputStream fileOutputStream2 = new FileOutputStream(file);){
                    sSLSelfSignedCertificateGenerator.createCertificateAndPrivateKey(fileOutputStream, fileOutputStream2, string, string5, string6, string7);
                }
                catch (Throwable throwable) {
                    c.o.error(throwable);
                    ((File)object).delete();
                    file.delete();
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
                }
                if (properties == null) break;
                properties.setProperty(ConfigKey.LISTENER_SSL_CERTIFICATE.getKey(), file.getAbsolutePath());
                properties.setProperty(ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey(), ((File)object).getAbsolutePath());
                break;
            }
            case "action.webserver.restart": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.AskRestart, this.translate(settings, "action.webserver.restart.msg", new Object[0]), (String)null));
                break;
            }
            case "action.webserver.letsencrypt": {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, "", "action.webserver.letsencrypt"));
                break;
            }
            case "action.webserver.letsencrypt.ok": {
                String string = settings.getValue("acme.domain");
                if (string == null || string.trim().isEmpty()) break;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "action.webserver.letsencrypt.success", new Object[0]), "acme.domain"));
                if (properties == null) break;
                properties.setProperty(WebConfigKeys.CERTIFICATE_DOMAINS.getKey(), string);
                break;
            }
            case "action.validate.certificate": {
                this.a(messages, settings, true);
                if (messages.size() != 0) break;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "action.validate.success", new Object[0]), "action.validate.certificate"));
                break;
            }
        }
    }

    private void e(@Nonnull ConfigStructureSettings configStructureSettings) {
        GUID gUID2;
        if (!ServerPluginManager.getInstance().isPluginLoaded("taskplanner")) {
            return;
        }
        TaskPlanner taskPlanner = TaskPlanner.getInstance();
        for (GUID gUID2 : taskPlanner.getAllTaskIDs()) {
            TaskDefinition taskDefinition = taskPlanner.getTaskDefinition(gUID2);
            if (taskDefinition == null) continue;
            for (JobDefinition jobDefinition : taskDefinition.getJobs()) {
                if (!"job.acme".equals(jobDefinition.getExtensionName())) continue;
                return;
            }
        }
        TaskDefinition taskDefinition = new TaskDefinition(this.translate(configStructureSettings, "letsencrypt", new Object[0]));
        gUID2 = new TimeTriggerBuilder().withHourAndMinute(3, 0).withRepeating(RepeatInterval.MONTHLY).create();
        taskDefinition.addTrigger((TriggerDefinition)gUID2);
        taskDefinition.addJob(new JobDefinition("job.acme"));
        TaskPlannerForUsers.getInstance().addTask(taskDefinition);
    }

    private void a(@Nonnull ConfigStructureSettings configStructureSettings, File ... fileArray) {
        Object object;
        if (!SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER)) {
            return;
        }
        TaskPlanner taskPlanner = TaskPlanner.getInstance();
        TaskDefinition taskDefinition = null;
        File[] fileArray2 = null;
        block0: for (File[] fileArray3 : taskPlanner.getAllTaskIDs()) {
            TaskDefinition taskDefinition2 = taskPlanner.getTaskDefinition((GUID)fileArray3);
            if (taskDefinition2 == null) continue;
            for (File file : taskDefinition2.getJobs()) {
                if (!"job.SSLReload".equals(file.getExtensionName())) continue;
                taskDefinition = taskDefinition2;
                fileArray2 = fileArray3;
                object = new ArrayList(taskDefinition.getTriggers());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TriggerDefinition triggerDefinition = (TriggerDefinition)iterator.next();
                    if (!"trigger.filechange".equals(triggerDefinition.getExtensionName())) continue;
                    taskDefinition.removeTrigger(triggerDefinition);
                }
                TaskPlannerForUsers.getInstance().updateTask((GUID)fileArray2, taskDefinition);
                continue block0;
            }
        }
        if (taskDefinition == null) {
            taskDefinition = new TaskDefinition(this.translate(configStructureSettings, "fix", new Object[0]));
            taskDefinition.addJob(new JobDefinition("job.SSLReload"));
            fileArray2 = TaskPlannerForUsers.getInstance().addTask(taskDefinition);
        }
        if (fileArray2 == null) {
            return;
        }
        boolean bl = false;
        for (File file : fileArray) {
            if (file == null || file.getPath().isEmpty()) continue;
            object = FileChangeTriggerBuilder.createForFile((String)file.getPath());
            taskDefinition.addTrigger((TriggerDefinition)object);
            bl = true;
        }
        if (bl) {
            TaskPlannerForUsers.getInstance().updateTask(fileArray2, taskDefinition);
        } else {
            TaskPlannerForUsers.getInstance().removeTask(fileArray2);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="only administrator input is used")
    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "listener.ssl.certificate.type": 
            case "listener.ssl.domains": {
                a.y();
                break;
            }
            case "listener.ssl.certificate": 
            case "listener.ssl.privatekey": {
                File file = new File(settings.getValue(ConfigKey.LISTENER_SSL_CERTIFICATE));
                File file2 = new File(settings.getValue(ConfigKey.LISTENER_SSL_PRIVATEKEY));
                if (ServerPluginManager.getInstance().isPluginLoaded("taskplanner")) {
                    this.a(settings, file, file2);
                }
                a.y();
                break;
            }
            case "listener.ssl.certificate.upload": 
            case "listener.ssl.privatekey.upload": {
                try {
                    byte[] byArray = FileUploadConfigProperty.decodeUploadDataAsBytes((String)settings.getValue(WebConfigKeys.LISTENER_SSL_CERTIFICATE_UPLOAD));
                    byte[] byArray2 = FileUploadConfigProperty.decodeUploadDataAsBytes((String)settings.getValue(WebConfigKeys.LISTENER_SSL_PRIVATEKEY_UPLOAD));
                    com.inet.webserver.structure.a a2 = com.inet.webserver.structure.a.u();
                    com.inet.webserver.structure.a a3 = com.inet.webserver.structure.a.t();
                    a2.a(byArray2);
                    a3.a(byArray);
                    a.y();
                }
                catch (Exception exception) {
                    c.o.error((Throwable)exception);
                }
                return ConfigStructure.SaveState.SAVE;
            }
            case "serverURL": {
                if (Objects.equals(value, ConfigKey.SERVER_URL.getDefault())) {
                    value = null;
                }
                settings.save(ConfigKey.SERVER_URL, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "listener.header.http": 
            case "listener.header.https": {
                Json json = new Json();
                List list = (List)json.fromJson(value, ArrayList.class);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (list != null) {
                    for (List list2 : list) {
                        if (list2.size() != 2) continue;
                        hashMap.put((String)list2.get(0), (String)list2.get(1));
                    }
                }
                value = json.toJson(hashMap);
                settings.save(key, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "listener.ssl.redirect": {
                settings.save(ConfigKey.LISTENER_SSL_REDIRECT, value);
                return ConfigStructure.SaveState.RELOAD;
            }
        }
        return super.save(key, value, settings);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only admin input is used")
    private boolean a(String[] stringArray, @Nonnull ArrayList<ConfigValidationMsg> arrayList, @Nonnull ConfigStructureSettings configStructureSettings) {
        String string = "" + stringArray.hashCode();
        byte[] byArray = ("" + configStructureSettings.hashCode()).getBytes();
        com.inet.webserver.acme.a.a(string, byArray);
        StringBuilder stringBuilder = null;
        int n = arrayList.size();
        for (String string2 : stringArray) {
            void object;
            try {
                byte[] throwable;
                try {
                    throwable = IOFunctions.getFileBuffer((URL)new URL("http://" + string2 + "/.well-known/acme-challenge/" + string));
                }
                catch (IOException iOException) {
                    URLConnection uRLConnection = new URL("https://" + string2 + "/.well-known/acme-challenge/" + string).openConnection();
                    TrustAllTrustManager.trustAllCerticates((URLConnection)uRLConnection, (boolean)false);
                    try (InputStream inputStream = uRLConnection.getInputStream();){
                        throwable = IOFunctions.readBytes((InputStream)inputStream);
                    }
                }
                if (Arrays.equals(throwable, byArray)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                c.o.debug((Object)iOException);
                String string3 = string2 + " (error: " + StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException) + ")";
            }
            catch (Throwable throwable) {
                c.o.debug((Object)throwable);
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable), "acme.domain"));
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)object);
        }
        if (stringBuilder != null) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, "The following hosts are not listening on port 80 or 443: " + String.valueOf(stringBuilder), "acme.domain"));
        }
        com.inet.webserver.acme.a.e(string);
        return n - arrayList.size() == 0;
    }

    private static boolean f(@Nonnull ConfigStructureSettings configStructureSettings) {
        if (configStructureSettings.isFilter()) {
            return true;
        }
        return configStructureSettings.isFilter() || "letsencrypt".equals(configStructureSettings.getValue(WebConfigKeys.CERTIFICATE_TYPE)) || new com.inet.webserver.acme.b().isAvailable();
    }

    private static class a
    extends DefaultTimerTask {
        private static a X;

        private a() {
        }

        static synchronized void y() {
            if (X != null) {
                return;
            }
            X = new a();
            DefaultTimer.getInstance().schedule((DefaultTimerTask)X, 500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runImpl() throws Throwable {
            try {
                URL[] uRLArray = ListenerSettings.getCertificateURLs(ConfigurationManager.getInstance().getCurrent());
                URL uRL = uRLArray[0];
                URL uRL2 = uRLArray[1];
                if (uRL != null && uRL2 != null) {
                    f f2 = new f(uRL, uRL2);
                    com.inet.webserver.b.a(f2);
                }
            }
            catch (Exception exception) {
                c.o.error((Throwable)exception);
            }
            finally {
                X = null;
            }
        }
    }
}

