/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

public interface QuicheConstants {
    public static final int QUICHE_PROTOCOL_VERSION = 1;
    public static final int QUICHE_MAX_CONN_ID_LEN = 20;
    public static final int QUICHE_MIN_CLIENT_INITIAL_LEN = 1200;

    public static interface tls_alert {
        public static final long CLOSE_NOTIFY = 0L;
        public static final long UNEXPECTED_MESSAGE = 10L;
        public static final long BAD_RECORD_MAC = 20L;
        public static final long RECORD_OVERFLOW = 22L;
        public static final long HANDSHAKE_FAILURE = 40L;
        public static final long BAD_CERTIFICATE = 42L;
        public static final long UNSUPPORTED_CERTIFICATE = 43L;
        public static final long CERTIFICATE_REVOKED = 44L;
        public static final long CERTIFICATE_EXPIRED = 45L;
        public static final long CERTIFICATE_UNKNOWN = 46L;
        public static final long ILLEGAL_PARAMETER = 47L;
        public static final long UNKNOWN_CA = 48L;
        public static final long ACCESS_DENIED = 49L;
        public static final long DECODE_ERROR = 50L;
        public static final long DECRYPT_ERROR = 51L;
        public static final long TOO_MANY_CIDS_REQUESTED = 52L;
        public static final long PROTOCOL_VERSION = 70L;
        public static final long INSUFFICIENT_SECURITY = 71L;
        public static final long INTERNAL_ERROR = 80L;
        public static final long INAPPROPRIATE_FALLBACK = 86L;
        public static final long USER_CANCELED = 90L;
        public static final long MISSING_EXTENSION = 109L;
        public static final long UNSUPPORTED_EXTENSION = 110L;
        public static final long UNRECOGNIZED_NAME = 112L;
        public static final long BAD_CERTIFICATE_STATUS_RESPONSE = 113L;
        public static final long UNKNOWN_PSK_IDENTITY = 115L;
        public static final long CERTIFICATE_REQUIRED = 116L;
        public static final long NO_APPLICATION_PROTOCOL = 120L;

        public static String errToString(long err) {
            if (err == 0L) {
                return "CLOSE_NOTIFY";
            }
            if (err == 10L) {
                return "UNEXPECTED_MESSAGE";
            }
            if (err == 20L) {
                return "BAD_RECORD_MAC";
            }
            if (err == 22L) {
                return "RECORD_OVERFLOW";
            }
            if (err == 40L) {
                return "HANDSHAKE_FAILURE";
            }
            if (err == 42L) {
                return "BAD_CERTIFICATE";
            }
            if (err == 43L) {
                return "UNSUPPORTED_CERTIFICATE";
            }
            if (err == 44L) {
                return "CERTIFICATE_REVOKED";
            }
            if (err == 45L) {
                return "CERTIFICATE_EXPIRED";
            }
            if (err == 46L) {
                return "CERTIFICATE_UNKNOWN";
            }
            if (err == 47L) {
                return "ILLEGAL_PARAMETER";
            }
            if (err == 48L) {
                return "UNKNOWN_CA";
            }
            if (err == 49L) {
                return "ACCESS_DENIED";
            }
            if (err == 50L) {
                return "DECODE_ERROR";
            }
            if (err == 51L) {
                return "DECRYPT_ERROR";
            }
            if (err == 52L) {
                return "TOO_MANY_CIDS_REQUESTED";
            }
            if (err == 70L) {
                return "PROTOCOL_VERSION";
            }
            if (err == 71L) {
                return "INSUFFICIENT_SECURITY";
            }
            if (err == 80L) {
                return "INTERNAL_ERROR";
            }
            if (err == 86L) {
                return "INAPPROPRIATE_FALLBACK";
            }
            if (err == 90L) {
                return "USER_CANCELED";
            }
            if (err == 109L) {
                return "MISSING_EXTENSION";
            }
            if (err == 110L) {
                return "UNSUPPORTED_EXTENSION";
            }
            if (err == 112L) {
                return "UNRECOGNIZED_NAME";
            }
            if (err == 113L) {
                return "BAD_CERTIFICATE_STATUS_RESPONSE";
            }
            if (err == 115L) {
                return "UNKNOWN_PSK_IDENTITY";
            }
            if (err == 116L) {
                return "CERTIFICATE_REQUIRED";
            }
            if (err == 120L) {
                return "NO_APPLICATION_PROTOCOL";
            }
            return "?? " + err;
        }
    }

    public static interface quic_error {
        public static final long NO_ERROR = 0L;
        public static final long INTERNAL_ERROR = 1L;
        public static final long CONNECTION_REFUSED = 2L;
        public static final long FLOW_CONTROL_ERROR = 3L;
        public static final long STREAM_LIMIT_ERROR = 4L;
        public static final long STREAM_STATE_ERROR = 5L;
        public static final long FINAL_SIZE_ERROR = 6L;
        public static final long FRAME_ENCODING_ERROR = 7L;
        public static final long TRANSPORT_PARAMETER_ERROR = 8L;
        public static final long CONNECTION_ID_LIMIT_ERROR = 9L;
        public static final long PROTOCOL_VIOLATION = 10L;
        public static final long INVALID_TOKEN = 11L;
        public static final long APPLICATION_ERROR = 12L;
        public static final long CRYPTO_BUFFER_EXCEEDED = 13L;
        public static final long KEY_UPDATE_ERROR = 14L;
        public static final long AEAD_LIMIT_REACHED = 15L;
        public static final long NO_VIABLE_PATH = 16L;
        public static final long VERSION_NEGOTIATION_ERROR = 17L;

        public static String errToString(long err) {
            if (err == 0L) {
                return "NO_ERROR";
            }
            if (err == 1L) {
                return "INTERNAL_ERROR";
            }
            if (err == 2L) {
                return "CONNECTION_REFUSED";
            }
            if (err == 3L) {
                return "FLOW_CONTROL_ERROR";
            }
            if (err == 4L) {
                return "STREAM_LIMIT_ERROR";
            }
            if (err == 5L) {
                return "STREAM_STATE_ERROR";
            }
            if (err == 6L) {
                return "FINAL_SIZE_ERROR";
            }
            if (err == 7L) {
                return "FRAME_ENCODING_ERROR";
            }
            if (err == 8L) {
                return "TRANSPORT_PARAMETER_ERROR";
            }
            if (err == 9L) {
                return "CONNECTION_ID_LIMIT_ERROR";
            }
            if (err == 10L) {
                return "PROTOCOL_VIOLATION";
            }
            if (err == 11L) {
                return "INVALID_TOKEN";
            }
            if (err == 12L) {
                return "APPLICATION_ERROR";
            }
            if (err == 13L) {
                return "CRYPTO_BUFFER_EXCEEDED";
            }
            if (err == 14L) {
                return "KEY_UPDATE_ERROR";
            }
            if (err == 15L) {
                return "AEAD_LIMIT_REACHED";
            }
            if (err == 16L) {
                return "NO_VIABLE_PATH";
            }
            if (err == 17L) {
                return "VERSION_NEGOTIATION_ERROR";
            }
            if (err >= 256L && err <= 511L) {
                return "CRYPTO_ERROR " + tls_alert.errToString(err - 256L);
            }
            return "?? " + err;
        }
    }

    public static interface quiche_error {
        public static final long QUICHE_ERR_DONE = -1L;
        public static final long QUICHE_ERR_BUFFER_TOO_SHORT = -2L;
        public static final long QUICHE_ERR_UNKNOWN_VERSION = -3L;
        public static final long QUICHE_ERR_INVALID_FRAME = -4L;
        public static final long QUICHE_ERR_INVALID_PACKET = -5L;
        public static final long QUICHE_ERR_INVALID_STATE = -6L;
        public static final long QUICHE_ERR_INVALID_STREAM_STATE = -7L;
        public static final long QUICHE_ERR_INVALID_TRANSPORT_PARAM = -8L;
        public static final long QUICHE_ERR_CRYPTO_FAIL = -9L;
        public static final long QUICHE_ERR_TLS_FAIL = -10L;
        public static final long QUICHE_ERR_FLOW_CONTROL = -11L;
        public static final long QUICHE_ERR_STREAM_LIMIT = -12L;
        public static final long QUICHE_ERR_FINAL_SIZE = -13L;
        public static final long QUICHE_ERR_CONGESTION_CONTROL = -14L;
        public static final long QUICHE_ERR_STREAM_STOPPED = -15L;
        public static final long QUICHE_ERR_STREAM_RESET = -16L;
        public static final long QUICHE_ERR_ID_LIMIT = -17L;
        public static final long QUICHE_ERR_OUT_OF_IDENTIFIERS = -18L;
        public static final long QUICHE_ERR_KEY_UPDATE = -19L;
        public static final long QUICHE_ERR_CRYPTO_BUFFER_EXCEEDED = -20L;
        public static final long QUICHE_ERR_INVALID_ACK_RANGE = -21L;
        public static final long QUICHE_ERR_OPTIMISTIC_ACK_DETECTED = -22L;

        public static String errToString(long err) {
            if (err == -1L) {
                return "QUICHE_ERR_DONE";
            }
            if (err == -2L) {
                return "QUICHE_ERR_BUFFER_TOO_SHORT";
            }
            if (err == -3L) {
                return "QUICHE_ERR_UNKNOWN_VERSION";
            }
            if (err == -4L) {
                return "QUICHE_ERR_INVALID_FRAME";
            }
            if (err == -5L) {
                return "QUICHE_ERR_INVALID_PACKET";
            }
            if (err == -6L) {
                return "QUICHE_ERR_INVALID_STATE";
            }
            if (err == -7L) {
                return "QUICHE_ERR_INVALID_STREAM_STATE";
            }
            if (err == -8L) {
                return "QUICHE_ERR_INVALID_TRANSPORT_PARAM";
            }
            if (err == -9L) {
                return "QUICHE_ERR_CRYPTO_FAIL";
            }
            if (err == -10L) {
                return "QUICHE_ERR_TLS_FAIL";
            }
            if (err == -11L) {
                return "QUICHE_ERR_FLOW_CONTROL";
            }
            if (err == -12L) {
                return "QUICHE_ERR_STREAM_LIMIT";
            }
            if (err == -13L) {
                return "QUICHE_ERR_FINAL_SIZE";
            }
            if (err == -14L) {
                return "QUICHE_ERR_CONGESTION_CONTROL";
            }
            if (err == -15L) {
                return "QUICHE_ERR_STREAM_STOPPED";
            }
            if (err == -16L) {
                return "QUICHE_ERR_STREAM_RESET";
            }
            if (err == -17L) {
                return "QUICHE_ERR_ID_LIMIT";
            }
            if (err == -18L) {
                return "QUICHE_ERR_OUT_OF_IDENTIFIERS";
            }
            if (err == -19L) {
                return "QUICHE_ERR_KEY_UPDATE";
            }
            if (err == -20L) {
                return "QUICHE_ERR_CRYPTO_BUFFER_EXCEEDED";
            }
            if (err == -21L) {
                return "QUICHE_ERR_INVALID_ACK_RANGE";
            }
            if (err == -22L) {
                return "QUICHE_ERR_OPTIMISTIC_ACK_DETECTED";
            }
            return "?? " + err;
        }
    }

    public static interface quiche_cc_algorithm {
        public static final int QUICHE_CC_RENO = 0;
        public static final int QUICHE_CC_CUBIC = 1;
        public static final int QUICHE_CC_BBR = 2;
    }
}

