/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import org.eclipse.jetty.http3.HTTP3ErrorCode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class HTTP3Exception
extends RuntimeException {
    private final long errorCode;

    protected HTTP3Exception(long errorCode, String reason) {
        super(reason);
        this.errorCode = errorCode;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String getReason() {
        return this.getMessage();
    }

    public static final class SessionException
    extends HTTP3Exception {
        public SessionException(HTTP3ErrorCode errorCode, String message) {
            this(errorCode.code(), message);
        }

        public SessionException(long errorCode, String reason) {
            super(errorCode, reason);
        }
    }

    public static final class StreamException
    extends HTTP3Exception {
        public StreamException(HTTP3ErrorCode errorCode, String message) {
            this(errorCode.code(), message);
        }

        public StreamException(long errorCode, String message) {
            super(errorCode, message);
        }
    }
}

