/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.frames;

import java.util.HashMap;
import java.util.Map;

public enum FrameType {
    PADDING(0L),
    PING(1L),
    ACK(2L, 3L),
    RESET_STREAM(4L),
    STOP_SENDING(5L),
    CRYPTO(6L),
    NEW_TOKEN(7L),
    STREAM(8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L),
    MAX_DATA(16L),
    STREAM_MAX_DATA(17L),
    MAX_STREAMS(18L, 19L),
    DATA_BLOCKED(20L),
    STREAM_DATA_BLOCKED(21L),
    STREAMS_BLOCKED(22L, 23L),
    NEW_CONNECTION_ID(24L),
    RETIRE_CONNECTION_ID(25L),
    PATH_CHALLENGE(26L),
    PATH_RESPONSE(27L),
    CONNECTION_CLOSE(28L, 29L),
    HANDSHAKE_DONE(30L);


    public static FrameType from(long type) {
        FrameType frameType = Types.types.get(type);
        if (frameType != null) {
            return frameType;
        }
        return null;
    }

    private FrameType(long ... types) {
        for (long type : types) {
            Types.types.put(type, this);
        }
    }

    private static class Types {
        private static final Map<Long, FrameType> types = new HashMap<Long, FrameType>();

        private Types() {
        }
    }
}

