/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.util;

import org.eclipse.jetty.quic.util.ErrorCode;

public class QuicException
extends RuntimeException {
    private final ErrorCode errorCode;
    private final long frameType;

    public QuicException(ErrorCode code, String reason) {
        this(code, reason, 0L);
    }

    public QuicException(ErrorCode code, String reason, long frameType) {
        super(reason);
        this.errorCode = code;
        this.frameType = frameType;
    }

    public QuicException(ErrorCode code, String reason, long frameType, Throwable cause) {
        super(reason, cause);
        this.errorCode = code;
        this.frameType = frameType;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public long getFrameType() {
        return this.frameType;
    }

    @Override
    public String toString() {
        return "%s %s frame[0x%x]".formatted(this.getErrorCode(), this.getMessage(), this.getFrameType());
    }
}

