/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheConnectionId {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheConnectionId.class);
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
    private final byte[] connectionId;
    private final int hashCode;

    private QuicheConnectionId(byte[] connectionId) {
        this.connectionId = Objects.requireNonNull(connectionId);
        this.hashCode = Arrays.hashCode(connectionId);
    }

    public static QuicheConnectionId fromPacket(ByteBuffer packet) {
        QuicheConnectionId connectionId;
        byte[] bytes = Quiche.probeConnectionId(packet);
        if (bytes != null && bytes.length == 0) {
            throw new IllegalStateException();
        }
        QuicheConnectionId quicheConnectionId = connectionId = bytes == null ? null : new QuicheConnectionId(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("snooped connection ID from packet: [{}]", (Object)connectionId);
        }
        return connectionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuicheConnectionId that = (QuicheConnectionId)obj;
        return Arrays.equals(this.connectionId, that.connectionId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return QuicheConnectionId.bytesToHex(this.connectionId);
    }

    private static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[c >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[c & 0xF];
        }
        return new String(hexChars, StandardCharsets.US_ASCII);
    }
}

