/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.server;

import com.inet.authentication.base.LoginManager;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.help.api.HelpPageContentPatcher;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.NopHttpServletResponse;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.persistence.MaintenanceMode;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.webapi.WebAPICoreServerPlugin;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIAccessProvider;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.interfaces.TokenFromParentHandler;
import com.inet.plugin.webapi.api.interfaces.TypedPathToken;
import com.inet.plugin.webapi.server.data.APIInformation;
import com.inet.plugin.webapi.server.data.APIInformationList;
import com.inet.plugin.webapi.server.interfaces.b;
import com.inet.plugin.webapi.server.interfaces.c;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class d
implements PluginServlet {
    private static d s = null;
    private HelpPageContentPatcher t = null;
    public static final WebAPIAccessProvider u = new com.inet.plugin.webapi.server.a();

    private d() {
    }

    public static d c() {
        if (s == null) {
            s = new d();
        }
        return s;
    }

    public void a(HelpPageContentPatcher helpPageContentPatcher) {
        if (helpPageContentPatcher == null) {
            throw new IllegalArgumentException("help page content patcher must not be null");
        }
        this.t = helpPageContentPatcher;
    }

    @Nonnull
    public String getPathSpec() {
        return "/api";
    }

    public void init(@Nonnull ServletConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public boolean a(HttpServletRequest httpServletRequest, boolean bl) {
        if (httpServletRequest.getParameter("method") != null) {
            return false;
        }
        boolean bl2 = LoginManager.isApplicationRequest((HttpServletRequest)httpServletRequest);
        if (!bl2 && bl) {
            return false;
        }
        Boolean[] booleanArray = new Boolean[]{bl2};
        try {
            com.inet.plugin.webapi.server.interfaces.d d2 = new com.inet.plugin.webapi.server.interfaces.d(httpServletRequest);
            this.a((HttpServletRequest)d2, (HttpServletResponse)new NopHttpServletResponse(), false, () -> {}, webAPIExtension -> Boolean.TRUE, (requestHandlerBase, object, list, webAPIAccessProvider) -> {
                if (booleanArray[0].booleanValue()) {
                    return;
                }
                if (TokenFromParentHandler.class.isAssignableFrom(requestHandlerBase.getClass())) {
                    TokenFromParentHandler tokenFromParentHandler = (TokenFromParentHandler)TokenFromParentHandler.class.cast(requestHandlerBase);
                    booleanArray[0] = tokenFromParentHandler.coreServletHasToHandleRequest((HttpServletRequest)d2, object, list);
                } else {
                    booleanArray[0] = requestHandlerBase.coreServletHasToHandleRequest((HttpServletRequest)d2, list);
                }
            }, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return booleanArray[0];
    }

    public void service(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        VetoManager vetoManager;
        if (this.a(request, false)) {
            ResponseWriter.ok(response);
        }
        if ((vetoManager = VetoManager.getInstance()).isCurrentlyVetoed()) {
            ResponseWriter.unavailable(response);
            throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("service.unavailable.vetoed", new Object[0]));
        }
        if (request.getRequestURI().endsWith("/swagger.json")) {
            com.inet.plugin.webapi.server.swagger.d.j().service(request, response);
            return;
        }
        com.inet.plugin.webapi.server.interfaces.d d2 = new com.inet.plugin.webapi.server.interfaces.d(request);
        com.inet.plugin.webapi.server.interfaces.a a2 = () -> this.a((HttpServletRequest)d2, response);
        c<WebAPIExtension, Boolean> c2 = webAPIExtension -> this.a((WebAPIExtension)webAPIExtension, (HttpServletRequest)d2, response);
        b b2 = d.a(d2, response);
        this.a((HttpServletRequest)d2, response, true, a2, c2, b2, false);
    }

    private static <INPUT, OUTPUT, PATH_TYPE> b<INPUT, OUTPUT, PATH_TYPE> a(com.inet.plugin.webapi.server.interfaces.d d2, HttpServletResponse httpServletResponse) {
        return (requestHandlerBase, object, list, webAPIAccessProvider) -> {
            Object r = null;
            try (UserAccountScope userAccountScope = webAPIAccessProvider.getUserAccountScopeForHandler(requestHandlerBase, (HttpServletRequest)d2, httpServletResponse, list);){
                Object INPUT = null;
                try {
                    INPUT = requestHandlerBase.getJsonFromRequest((HttpServletRequest)d2);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new ClientMessageException(illegalStateException.getMessage());
                }
                if (TokenFromParentHandler.class.isAssignableFrom(requestHandlerBase.getClass())) {
                    TokenFromParentHandler tokenFromParentHandler = (TokenFromParentHandler)TokenFromParentHandler.class.cast(requestHandlerBase);
                    r = tokenFromParentHandler.handle((HttpServletRequest)d2, httpServletResponse, INPUT, object, list, d2.f());
                } else {
                    r = requestHandlerBase.handle((HttpServletRequest)d2, httpServletResponse, INPUT, list, d2.f());
                }
                if (requestHandlerBase.shouldSendJsonResponse() && r != null && !httpServletResponse.isCommitted()) {
                    ResponseWriter.json(httpServletResponse, r, 0);
                }
            }
            finally {
                webAPIAccessProvider.postProcessRequest(requestHandlerBase, (HttpServletRequest)d2, httpServletResponse, r);
            }
        };
    }

    protected <INPUT, OUTPUT, PATH_TOKEN> void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, com.inet.plugin.webapi.server.interfaces.a a2, c<WebAPIExtension, Boolean> c2, b<INPUT, OUTPUT, PATH_TOKEN> b2, boolean bl2) throws IOException {
        WebAPIExtension webAPIExtension;
        List<String> list = this.b(httpServletRequest);
        if (list.isEmpty()) {
            a2.accept();
            return;
        }
        String string = list.get(0);
        try {
            webAPIExtension = (WebAPIExtension)ServerPluginManager.getInstance().getSingleInstanceByName(WebAPIExtension.class, string, false);
        }
        catch (IllegalStateException illegalStateException) {
            ResponseWriter.notFound(httpServletResponse);
            return;
        }
        list = list.subList(1, list.size());
        WebAPIAccessProvider webAPIAccessProvider = webAPIExtension.getWebAPIAccessProvider(httpServletRequest, list);
        if (webAPIAccessProvider.equals(u)) {
            try {
                String string2 = (String)httpServletRequest.getAttribute("webapi-access-provider");
                if (string2 != null) {
                    webAPIAccessProvider = (WebAPIAccessProvider)ServerPluginManager.getInstance().getSingleInstanceByName(WebAPIAccessProvider.class, string2, false);
                }
            }
            catch (ClassCastException | IllegalStateException runtimeException) {
                // empty catch block
            }
        }
        if (bl && !webAPIAccessProvider.isWebApiAccessGranted(httpServletRequest, httpServletResponse)) {
            if (!httpServletResponse.isCommitted()) {
                ResponseWriter.forbidden(httpServletResponse);
            }
            return;
        }
        boolean bl3 = Boolean.TRUE.equals(httpServletRequest.getAttribute("WebAPIRequestForHelp"));
        if (!webAPIAccessProvider.isAccessToExtensionGranted(webAPIExtension, httpServletRequest, httpServletResponse, list)) {
            if (!httpServletResponse.isCommitted()) {
                ResponseWriter.forbidden(httpServletResponse);
                AccessDeniedException accessDeniedException = new AccessDeniedException((ErrorCode)BaseErrorCode.UserLoginRequired, new Object[]{""});
                Permission permission = webAPIExtension.getRequiredPermission(httpServletRequest, list);
                if (permission != null) {
                    accessDeniedException = new AccessDeniedException(permission);
                }
                throw accessDeniedException;
            }
            return;
        }
        if (list.size() == 0 || list.get(0).isEmpty()) {
            try {
                RequestHandler<?, ?> requestHandler = webAPIExtension.getGenericRequestHandler();
                if (!bl3 && requestHandler != null && TypedPathToken.class.isAssignableFrom(requestHandler.getClass())) {
                    if (!requestHandler.isAvailable()) {
                        throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("webapi.extensionNotAvailable", new Object[0]));
                    }
                    TypedPathToken typedPathToken = (TypedPathToken)((Object)requestHandler);
                    b2.accept(requestHandler, typedPathToken.typeFor(null), list, webAPIAccessProvider);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (!c2.accept(webAPIExtension).booleanValue()) {
                ResponseWriter.notFound(httpServletResponse);
            }
            return;
        }
        Object object = null;
        RequestHandlerBase<?, ?> requestHandlerBase = null;
        try {
            a a3 = this.a(list, webAPIExtension, bl3);
            requestHandlerBase = a3.v;
            object = a3.w;
            list = PathTokenizer.originalTokensFor(httpServletRequest.getPathInfo(), a3.x);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (requestHandlerBase == null) {
            if (!bl2 || !c2.accept(webAPIExtension).booleanValue()) {
                ResponseWriter.notFound(httpServletResponse);
            }
            return;
        }
        if (!requestHandlerBase.isAllowedInMaintenanceMode() && MaintenanceMode.NONE != MaintenanceMode.getState()) {
            ResponseWriter.unavailable(httpServletResponse);
            throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("service.unavailable.maintenance", new Object[0]));
        }
        b2.accept(requestHandlerBase, object, list, webAPIAccessProvider);
    }

    private a a(List<String> list, RequestHandlerBase<?, ?> requestHandlerBase, boolean bl) {
        Object object;
        if (requestHandlerBase == null) {
            return null;
        }
        if (!requestHandlerBase.isAvailable()) {
            throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("webapi.extensionNotAvailable", new Object[0]));
        }
        if (list.isEmpty()) {
            return new a(requestHandlerBase, null, list);
        }
        String string2 = list.get(0);
        a a2 = this.a(list, (String string) -> requestHandlerBase.getHandler((String)string));
        if (a2 != null) {
            a a3;
            if (a2.x.size() > 0 && (a3 = this.a(a2.x, a2.v, bl)) != null && a3.v != null) {
                a2 = a3;
            }
            return a2;
        }
        a2 = new a(null, null, null);
        RequestHandler<?, ?> requestHandler = requestHandlerBase.getGenericRequestHandler();
        if (requestHandler == null) {
            return null;
        }
        if (TypedPathToken.class.isAssignableFrom(requestHandler.getClass())) {
            object = (TypedPathToken)((Object)requestHandler);
            boolean bl2 = object.canHandle(string2);
            if (bl2 || bl) {
                a2.w = bl ? null : object.typeFor(string2);
                a2.v = requestHandler;
            } else if (!bl2) {
                throw new ClientMessageException("The given path token '" + string2 + "' can not be handled.");
            }
        }
        if ((object = this.a(list = list.subList(1, list.size()), a2.v, bl)) != null && !((a)object).v.equals(a2.v)) {
            if (a2.w != null && ((a)object).w == null) {
                ((a)object).w = a2.w;
            }
            return object;
        }
        a2.x = list;
        return a2;
    }

    @Nullable
    private a a(List<String> list, Function<String, RequestHandlerBase<?, ?>> function) {
        for (int i = list.size(); i >= 0; --i) {
            String string = String.join((CharSequence)"/", list.subList(0, i));
            RequestHandlerBase<?, ?> requestHandlerBase = function.apply(string);
            if (requestHandlerBase == null) continue;
            list = list.subList(i, list.size());
            return new a(requestHandlerBase, null, list);
        }
        return null;
    }

    private List<String> b(HttpServletRequest httpServletRequest) {
        return PathTokenizer.convertPathToTokens(httpServletRequest.getPathInfo()).stream().map(string -> string.toLowerCase()).collect(Collectors.toList());
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        APIInformationList aPIInformationList = this.b(httpServletRequest, httpServletResponse);
        String string = httpServletResponse.getContentType();
        if (string != null && string.startsWith("application/json")) {
            ResponseWriter.json(httpServletResponse, aPIInformationList);
        } else {
            ResponseWriter.html(httpServletResponse, aPIInformationList.toString());
        }
    }

    public APIInformationList b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        List<WebAPIExtension> list = this.c(httpServletRequest, httpServletResponse);
        APIInformationList aPIInformationList = new APIInformationList();
        for (WebAPIExtension webAPIExtension : list) {
            APIInformation aPIInformation = APIInformation.apiInformationForExtension(webAPIExtension);
            aPIInformationList.add(aPIInformation);
        }
        return aPIInformationList;
    }

    public List<WebAPIExtension> c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList<WebAPIExtension> arrayList = new ArrayList<WebAPIExtension>();
        ServerPluginManager.getInstance().get(WebAPIExtension.class).forEach(webAPIExtension -> arrayList.add((WebAPIExtension)webAPIExtension));
        arrayList.removeIf(webAPIExtension -> !u.isAccessToExtensionGranted((WebAPIExtension)webAPIExtension, httpServletRequest, httpServletResponse, Collections.emptyList()));
        return arrayList;
    }

    private boolean a(WebAPIExtension webAPIExtension, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletResponse.getContentType();
        if (string != null && string.startsWith("application/json")) {
            return true;
        }
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (!serverPluginManager.isPluginLoaded("help")) {
            throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("help.pluginMissing", new Object[0]));
        }
        String string2 = webAPIExtension.getHelpPageKey();
        String string3 = this.a(this.a(string2, httpServletRequest), httpServletRequest, false);
        if (string3 == null || string3.isEmpty()) {
            return false;
        }
        ResponseWriter.html(httpServletResponse, string3);
        return true;
    }

    @Nullable
    protected String a(String string, HttpServletRequest httpServletRequest) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest)) + httpServletRequest.getContextPath();
        String string3 = null;
        if (this.t != null) {
            try {
                string3 = this.t.getPatchedHelpPageContent(ClientLocale.getThreadLocale(), string, false, string2);
            }
            catch (Exception exception) {
                WebAPICoreServerPlugin.LOGGER.debug((Object)exception);
            }
        }
        return string3;
    }

    protected String a(String string, HttpServletRequest httpServletRequest, boolean bl) {
        if (string == null) {
            if (this.a(httpServletRequest, true)) {
                return null;
            }
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            String string2 = !serverPluginManager.isPluginLoaded("help") ? WebAPICoreServerPlugin.MSG.getMsg("help.pluginMissing", new Object[0]) : WebAPICoreServerPlugin.MSG.getMsg("help.notAvailable", new Object[0]);
            if (!bl) {
                return "<p id='center'>" + string2 + "</p>";
            }
            throw new ClientMessageException(string2);
        }
        return string;
    }

    private class a {
        private RequestHandlerBase<?, ?> v = null;
        private Object w = null;
        private List<String> x = new ArrayList<String>();

        public a(RequestHandlerBase<?, ?> requestHandlerBase, Object object, List<String> list) {
            this.v = requestHandlerBase;
            this.w = object;
            this.x = list;
        }
    }
}

