/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.api.handler;

import com.inet.annotations.InternalApi;
import com.inet.http.ClientMessageException;
import com.inet.lib.io.PositionInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.webapi.WebAPICoreServerPlugin;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.interfaces.TypedPathToken;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class RequestHandlerBase<INPUT, OUTPUT> {
    @Nonnull
    private final String i;
    @Nonnull
    private final HashMap<String, RequestHandlerBase<?, ?>> j = new HashMap();
    @Nullable
    private Type k;
    @Nullable
    private Type l;
    @Nullable
    private RequestHandler<?, ?> m = null;

    public RequestHandlerBase(String ... pathComponents) {
        this.i = this.a(pathComponents);
        Class<?> clazz = this.getClass();
        Type type = null;
        do {
            if ((type = clazz.getGenericSuperclass()) instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length >= 2) continue;
            type = null;
            clazz = clazz.getSuperclass();
        } while (type == null && clazz != null && !clazz.equals(Object.class));
        if (type != null) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArray != null && typeArray.length > 0) {
                this.k = typeArray[0];
            }
            if (typeArray != null && typeArray.length > 1) {
                this.l = typeArray[1];
            }
        }
    }

    public RequestHandlerBase() {
        String string = null;
        if (NamedExtension.class.isAssignableFrom(this.getClass())) {
            string = ((NamedExtension)this).getExtensionName();
        }
        this.i = this.a(string);
    }

    private String a(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("path components must not be null or empty");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                throw new IllegalArgumentException("path element must not be null");
            }
            if (string.length() > 0 && string.charAt(0) == '/') {
                string = stringArray[i] = string.substring(1);
            }
            if (string.trim().isEmpty()) {
                throw new IllegalArgumentException("path element must not be empty after trim");
            }
            if (!string.matches("^([a-zA-Z\\.-0-9]+|v[0-9]+)$")) {
                throw new IllegalArgumentException("path element must contain only alphabet characters (a-z and A-Z) or represent a version string (v1, v2, ...): " + string);
            }
            if (string.length() < 25) continue;
            throw new IllegalArgumentException(String.format("path element must not be longer than %d characters", 24));
        }
        return String.join((CharSequence)"/", stringArray).toLowerCase();
    }

    public final String getName() {
        return this.i;
    }

    public boolean isAllowedInMaintenanceMode() {
        return false;
    }

    public boolean isAllowedWithoutAuthentication() {
        return false;
    }

    public final synchronized void registerRequestHandler(@Nonnull RequestHandlerBase<?, ?> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("request handler must not be null");
        }
        String string = handler.getName();
        if (this.j.containsKey(string)) {
            throw new IllegalArgumentException("There is already registed handler under the name: " + string);
        }
        this.j.put(string, handler);
    }

    @Nullable
    public final RequestHandlerBase<?, ?> getHandler(@Nonnull String name) {
        return this.j.get(name);
    }

    public final List<RequestHandlerBase<?, ?>> getAllHandlers() {
        return new ArrayList(this.j.values());
    }

    public boolean shouldSendJsonResponse() {
        return true;
    }

    public abstract String getHelpPageKey();

    public abstract OUTPUT handle(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nullable INPUT var3, @Nonnull List<String> var4, boolean var5) throws IOException;

    public Boolean coreServletHasToHandleRequest(@Nonnull HttpServletRequest request, @Nonnull List<String> pathTokens) {
        return Boolean.FALSE;
    }

    public final <Y> OUTPUT getTypedResponse(@Nonnull Y response) {
        try {
            return (OUTPUT)response;
        }
        catch (ClassCastException classCastException) {
            WebAPICoreServerPlugin.LOGGER.debug((Object)("Could not return typed response for: '" + String.valueOf(response.getClass()) + "', " + classCastException.getMessage()));
            return null;
        }
    }

    public final void setGenericRequestHandler(@Nullable RequestHandler<?, ?> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("The request handler must not be null");
        }
        if (!TypedPathToken.class.isAssignableFrom(handler.getClass())) {
            throw new IllegalArgumentException("The request handler has to implement TypedPathToken.");
        }
        if (this.m != null) {
            throw new IllegalArgumentException("A generic request handler has already been registered using the name: " + handler.getName());
        }
        this.m = handler;
    }

    public final RequestHandler<?, ?> getGenericRequestHandler() {
        return this.m;
    }

    public boolean isMethodAllowedForData(@Nonnull HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod()) || "PUT".equalsIgnoreCase(request.getMethod());
    }

    @Nullable
    public final INPUT getJsonFromRequest(@Nonnull HttpServletRequest request) {
        if (!this.isMethodAllowedForData(request)) {
            return null;
        }
        if (this.k != null && this.k != Object.class && this.k != Void.class) {
            try {
                return this.jsonFromRequest(request, this.k);
            }
            catch (Throwable throwable) {
                WebAPICoreServerPlugin.LOGGER.debug((Object)("Could not find JSON from request: " + throwable.getLocalizedMessage()));
                throw throwable;
            }
        }
        return null;
    }

    protected final INPUT jsonFromRequest(@Nonnull HttpServletRequest request, @Nonnull Type type) {
        try {
            Object t = this.jsonFromRequestWithType(request, type);
            return (INPUT)t;
        }
        catch (JsonException | IOException throwable) {
            WebAPICoreServerPlugin.LOGGER.debug((Object)throwable);
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof UTFDataFormatException)) continue;
                throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("webapi.utf8Error", new Object[]{throwable.getMessage()}));
            }
            throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("webapi.jsonError", new Object[]{throwable.getMessage()}));
        }
    }

    public final <T> T jsonFromRequestWithType(@Nonnull HttpServletRequest request, @Nonnull Type typeClass) throws JsonException, IOException {
        Part part;
        Json json = new Json();
        Object object2 = null;
        Object object3 = null;
        try {
            part = request.getPart("json");
            object3 = part.getInputStream();
        }
        catch (ServletException | IOException | IllegalStateException | NullPointerException throwable) {
            object3 = request.getInputStream();
        }
        part = new PositionInputStream((InputStream)object3);
        HashMap hashMap = new HashMap();
        try {
            object2 = json.fromJson((InputStream)part, typeClass, hashMap, null);
        }
        catch (JsonException | EOFException throwable) {
            if (part.getPosition() == 0L) {
                return null;
            }
            throw throwable;
        }
        if (!hashMap.isEmpty()) {
            throw new IllegalStateException(WebAPICoreServerPlugin.MSG.getMsg("webapi.additionalDataError", new Object[]{"'" + String.join((CharSequence)"', '", hashMap.keySet().stream().map(object -> object.toString()).collect(Collectors.toList())) + "'"}));
        }
        return (T)object2;
    }

    public boolean isAvailable() {
        return true;
    }

    @Nullable
    public final Type getInputType() {
        if (this.k != null && this.k != Object.class && this.k != Void.class) {
            return this.k;
        }
        return null;
    }

    @Nullable
    public final Type getOutputType() {
        if (this.l != null && this.l != Object.class && this.l != Void.class) {
            return this.l;
        }
        return null;
    }
}

