/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.server.swagger;

import com.inet.config.ConfigValue;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.JsonWriterFilter;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.WebAPICoreServerPlugin;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.annotation.PathInfo;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.server.swagger.a;
import com.inet.plugin.webapi.server.swagger.b;
import com.inet.plugin.webapi.server.swagger.c;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class d {
    private static final ConfigValue<Boolean> O = new ConfigValue(com.inet.plugin.webapi.structure.a.S);
    private static d P;

    public static d j() {
        if (P == null) {
            P = new d();
        }
        return P;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void service(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        OpenAPI openAPI = new OpenAPI();
        String string = null;
        List<String> list = PathTokenizer.convertPathToTokens(request.getPathInfo());
        if (list.size() > 0 && (StringFunctions.isEmpty((String)(string = list.get(0))) || "/swagger.json".endsWith(string))) {
            string = null;
        }
        Info info = new Info();
        info.setTitle(ApplicationDescription.get().getApplicationName() + " /// Web API");
        info.setVersion(ApplicationDescription.get().getVersion().toString());
        openAPI.setInfo(info);
        String string2 = ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request).toString();
        openAPI.externalDocs(new ExternalDocumentation().url(string2 + "/help/webapicore"));
        Server server = new Server();
        server.setUrl(string2 + "/api");
        openAPI.addServersItem(server);
        Components components = new Components();
        components.setSchemas(new HashMap());
        openAPI.setComponents(components);
        this.a(openAPI);
        @Nonnull List list2 = ServerPluginManager.getInstance().get(WebAPIExtension.class);
        if (string != null && !StringFunctions.isEmpty((String)string)) {
            String string3 = string;
            list2.removeIf(webAPIExtension -> !webAPIExtension.getExtensionName().equals(string3));
        }
        if (!((Boolean)O.get()).booleanValue()) {
            list2.removeIf(webAPIExtension -> !webAPIExtension.isAllowedWithoutAuthentication() && !SystemPermissionChecker.checkAccess((Permission)webAPIExtension.getRequiredPermission(request, list)));
            info.setDescription(WebAPICoreServerPlugin.MSG.getMsg("webapi.swagger.public.hint", new Object[]{list2.size()}));
        }
        list2.forEach(webAPIExtension -> {
            io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag();
            tag.setName(webAPIExtension.extensionDisplayName());
            tag.setDescription(webAPIExtension.extensionDescription());
            if (openAPI.getTags() == null) {
                openAPI.setTags(new ArrayList());
            }
            if (openAPI.getTags().stream().noneMatch(tag2 -> tag.getName().equals(tag2.getName()))) {
                openAPI.addTagsItem(tag);
            }
            this.a((WebAPIExtension)webAPIExtension, openAPI, tag);
        });
        ResponseWriter.json(response, openAPI, 200, (JsonWriterFilter)new b());
    }

    private void a(@Nonnull OpenAPI openAPI) {
        SecurityScheme securityScheme;
        String string;
        if (ServerPluginManager.getInstance().isPluginLoaded("authentication.token")) {
            string = "bearerAuth";
            securityScheme = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer");
            openAPI.addSecurityItem(new SecurityRequirement().addList(string));
            openAPI.getComponents().addSecuritySchemes(string, securityScheme);
        }
        string = "basicAuth";
        securityScheme = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic");
        openAPI.addSecurityItem(new SecurityRequirement().addList(string));
        openAPI.getComponents().addSecuritySchemes(string, securityScheme);
    }

    private void a(WebAPIExtension webAPIExtension, @Nonnull OpenAPI openAPI, io.swagger.v3.oas.models.tags.Tag tag) {
        RequestHandler<?, ?> requestHandler = webAPIExtension.getGenericRequestHandler();
        if (requestHandler != null) {
            this.a(requestHandler, "/" + webAPIExtension.getName(), new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), openAPI, tag);
        }
        webAPIExtension.getAllHandlers().forEach(requestHandlerBase -> this.a((RequestHandlerBase<?, ?>)requestHandlerBase, "/" + webAPIExtension.getName(), (List<io.swagger.v3.oas.models.parameters.Parameter>)new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), openAPI, tag));
    }

    private void a(@Nonnull RequestHandlerBase<?, ?> requestHandlerBase, @Nonnull String string, @Nonnull List<io.swagger.v3.oas.models.parameters.Parameter> list, @Nonnull OpenAPI openAPI, io.swagger.v3.oas.models.tags.Tag tag) {
        Object object;
        if (!requestHandlerBase.isAvailable()) {
            return;
        }
        String string2 = string + "/" + requestHandlerBase.getName();
        String[] stringArray = new String[]{string2};
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> arrayList = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(list);
        Annotation[] annotationArray = (Annotation[])Stream.of(requestHandlerBase.getClass().getDeclaredConstructors()).map(constructor -> constructor.getAnnotations()).flatMap(Arrays::stream).toArray(Annotation[]::new);
        Consumer<PathInfo> consumer = pathInfo -> {
            stringArray[0] = a.c(pathInfo.path(), stringArray[0]);
        };
        if (RequestHandler.WithCurrentPathToken.class.isAssignableFrom(requestHandlerBase.getClass())) {
            stringArray[0] = string + "/{" + requestHandlerBase.getName() + "}";
            string2 = stringArray[0];
            object = new io.swagger.v3.oas.models.parameters.Parameter();
            object.setName(requestHandlerBase.getName());
            object.in("path");
            object.required(Boolean.TRUE);
            object.setSchema((Schema)new StringSchema());
            a.b(annotationArray, arg_0 -> d.a((io.swagger.v3.oas.models.parameters.Parameter)object, arg_0));
            consumer = arg_0 -> d.a((io.swagger.v3.oas.models.parameters.Parameter)object, stringArray, arg_0);
            arrayList.add((io.swagger.v3.oas.models.parameters.Parameter)object);
        }
        a.c(annotationArray, consumer);
        this.a(requestHandlerBase, openAPI, stringArray[0], arrayList, tag);
        object = string2;
        a.d(annotationArray, alternativePathInfo -> {
            if (StringFunctions.isEmpty((String)alternativePathInfo.pathInfo().path())) {
                return;
            }
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> arrayList = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(arrayList);
            PathItem pathItem = this.a(requestHandlerBase, openAPI, alternativePathInfo.pathInfo().path(), arrayList, tag);
            for (Parameter parameter : alternativePathInfo.parameter()) {
                io.swagger.v3.oas.models.parameters.Parameter parameter2 = a.a(openAPI.getComponents()).a(parameter);
                pathItem.addParametersItem(parameter2);
            }
            Operation operation = pathItem.getPost();
            operation.description(a.c(alternativePathInfo.pathInfo().description(), operation.getDescription()));
            operation.summary(a.c(alternativePathInfo.pathInfo().summary(), operation.getSummary()));
        });
        RequestHandler<?, ?> requestHandler = requestHandlerBase.getGenericRequestHandler();
        if (requestHandler != null) {
            this.a(requestHandler, string2, arrayList, openAPI, tag);
        }
        requestHandlerBase.getAllHandlers().forEach(arg_0 -> this.a((String)object, arrayList, openAPI, tag, arg_0));
    }

    private boolean a(@Nullable List<io.swagger.v3.oas.models.parameters.Parameter> list, @Nonnull io.swagger.v3.oas.models.parameters.Parameter parameter2) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        String string = parameter2.getName() + ":" + parameter2.getIn();
        return list.stream().anyMatch(parameter -> (parameter.getName() + ":" + parameter.getIn()).equals(string));
    }

    private void a(@Nonnull PathItem pathItem, @Nonnull io.swagger.v3.oas.models.parameters.Parameter parameter) {
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> arrayList = pathItem.getParameters();
        if (arrayList == null) {
            arrayList = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            pathItem.setParameters(arrayList);
        }
        if (!this.a(arrayList, parameter)) {
            pathItem.addParametersItem(parameter);
        }
    }

    private void a(@Nonnull Operation operation, @Nonnull io.swagger.v3.oas.models.parameters.Parameter parameter) {
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> arrayList = operation.getParameters();
        if (arrayList == null) {
            arrayList = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            operation.setParameters(arrayList);
        }
        if (!this.a(arrayList, parameter)) {
            operation.addParametersItem(parameter);
        }
    }

    @Nullable
    private Description a(@Nonnull PathItem pathItem, @Nonnull Annotation annotation, @Nonnull OpenAPI openAPI) {
        if (annotation instanceof io.swagger.v3.oas.annotations.Operation) {
            io.swagger.v3.oas.annotations.Operation operation2 = (io.swagger.v3.oas.annotations.Operation)annotation;
            Operation operation3 = this.a(pathItem, operation2.method());
            Operation operation4 = a.a(openAPI.getComponents()).a(operation3, operation2);
            if (operation3 != null && operation3.getTags() != null) {
                for (String string : operation3.getTags()) {
                    if (operation4.getTags().contains(string)) continue;
                    operation4.addTagsItem(string);
                }
            }
            this.a(pathItem, operation4, operation2.method());
        } else if (annotation instanceof Parameters) {
            Parameters parameters = (Parameters)annotation;
            for (Parameter parameter : parameters.value()) {
                this.a(pathItem, (Annotation)parameter, openAPI);
            }
        } else if (annotation instanceof Parameter) {
            Parameter parameter = (Parameter)annotation;
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = a.a(openAPI.getComponents()).a(parameter);
            if (parameter2 != null) {
                if (ParameterIn.PATH.equals((Object)parameter.in())) {
                    this.a(pathItem, parameter2);
                } else {
                    this.a(pathItem, (Operation operation) -> this.a((Operation)operation, parameter2));
                }
            }
        } else if (annotation instanceof Tags) {
            Tags tags = (Tags)annotation;
            for (Tag tag : tags.value()) {
                this.a(pathItem, (Annotation)tag, openAPI);
            }
        } else if (annotation instanceof Tag) {
            Tag tag = (Tag)annotation;
            if (!StringFunctions.isEmpty((String)tag.name())) {
                this.a(pathItem, (Operation operation) -> {
                    if (operation.getTags() == null) {
                        operation.setTags(new ArrayList());
                    }
                    if (!operation.getTags().contains(tag.name())) {
                        operation.addTagsItem(tag.name());
                    }
                });
                io.swagger.v3.oas.models.tags.Tag tag3 = new io.swagger.v3.oas.models.tags.Tag().name(tag.name()).description(a.e(tag.description()));
                if (openAPI.getTags() == null) {
                    openAPI.setTags(new ArrayList());
                }
                if (openAPI.getTags().stream().noneMatch(tag2 -> tag.name().equals(tag2.getName()))) {
                    openAPI.addTagsItem(tag3);
                }
            }
        } else if (annotation instanceof ApiResponses) {
            ApiResponses apiResponses = (ApiResponses)annotation;
            this.a(pathItem, (Operation operation) -> {
                io.swagger.v3.oas.models.responses.ApiResponses apiResponses2 = a.a(openAPI.getComponents()).a(apiResponses.value());
                apiResponses2.forEach((string, apiResponse) -> this.a((Operation)operation).addApiResponse(string, apiResponse));
            });
        } else if (annotation instanceof io.swagger.v3.oas.annotations.responses.ApiResponse) {
            io.swagger.v3.oas.annotations.responses.ApiResponse apiResponse = (io.swagger.v3.oas.annotations.responses.ApiResponse)annotation;
            this.a(pathItem, (Operation operation) -> {
                io.swagger.v3.oas.models.responses.ApiResponses apiResponses = a.a(openAPI.getComponents()).a(new io.swagger.v3.oas.annotations.responses.ApiResponse[]{apiResponse});
                apiResponses.forEach((string, apiResponse) -> this.a((Operation)operation).addApiResponse(string, apiResponse));
            });
        } else if (annotation instanceof Description) {
            return (Description)annotation;
        }
        return null;
    }

    private void a(@Nonnull PathItem pathItem, Consumer<Operation> consumer) {
        Stream.of(pathItem.getGet(), pathItem.getPost(), pathItem.getPut(), pathItem.getDelete(), pathItem.getOptions(), pathItem.getHead(), pathItem.getPatch()).filter(Objects::nonNull).forEach(consumer::accept);
    }

    @Nullable
    private Description a(@Nonnull PathItem pathItem, @Nonnull RequestHandlerBase<?, ?> requestHandlerBase, @Nonnull OpenAPI openAPI) {
        Description description = null;
        @Nonnull Annotation[] annotationArray = requestHandlerBase.getClass().getAnnotations();
        Object[] objectArray = annotationArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation = objectArray[i];
            Object object = this.a(pathItem, annotation, openAPI);
            if (object == null) continue;
            if (description != null) {
                throw new IllegalArgumentException("A description was already set for extension " + requestHandlerBase.getName());
            }
            description = object;
        }
        for (Object object : objectArray = requestHandlerBase.getClass().getMethods()) {
            Annotation[] annotationArray2;
            for (Annotation annotation : annotationArray2 = ((AccessibleObject)object).getAnnotations()) {
                Description description2 = this.a(pathItem, annotation, openAPI);
                if (description2 == null) continue;
                if (description != null) {
                    throw new IllegalArgumentException("A description was already set for extension " + requestHandlerBase.getName());
                }
                description = description2;
            }
        }
        return description;
    }

    private PathItem a(@Nonnull RequestHandlerBase<?, ?> requestHandlerBase, @Nonnull OpenAPI openAPI, @Nonnull String string, @Nonnull List<io.swagger.v3.oas.models.parameters.Parameter> list, @Nonnull io.swagger.v3.oas.models.tags.Tag tag) {
        Object object;
        PathItem pathItem = new PathItem();
        list.forEach(parameter -> this.a(pathItem, (io.swagger.v3.oas.models.parameters.Parameter)parameter));
        Operation operation = new Operation();
        operation.addTagsItem(tag.getName());
        @Nullable HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            object = ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest).toString();
            operation.externalDocs(new ExternalDocumentation().url((String)object + "/help/" + requestHandlerBase.getHelpPageKey()));
        }
        this.a(pathItem, operation, "POST");
        this.b(operation, requestHandlerBase, openAPI.getComponents());
        this.a(operation, requestHandlerBase, openAPI.getComponents());
        object = this.a(pathItem, requestHandlerBase, openAPI);
        if (object != null) {
            operation.summary(a.c(object.summary(), operation.getSummary()));
            operation.setDescription(a.c(object.description(), operation.getDescription()));
        }
        openAPI.path(string, pathItem);
        return pathItem;
    }

    private void a(@Nonnull Operation operation, @Nonnull RequestHandlerBase<?, ?> requestHandlerBase, @Nonnull Components components) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = this.a(operation);
        ApiResponse apiResponse = new ApiResponse();
        Type type = requestHandlerBase.getOutputType();
        if (type == null) {
            apiResponse.setDescription("");
            apiResponses.addApiResponse("200", apiResponse);
            return;
        }
        Content content = new Content();
        MediaType mediaType = new MediaType();
        Schema<?> schema = c.b(components).a(type);
        mediaType.setSchema(schema);
        content.addMediaType("application/json; charset=utf-8", mediaType);
        apiResponse.setContent(content);
        Schema schema2 = (Schema)components.getSchemas().get(c.f(type.getTypeName()));
        String string = schema2 != null && !StringFunctions.isEmpty((String)schema2.getDescription()) ? schema2.getDescription() : (schema != null && !StringFunctions.isEmpty((String)schema.getDescription()) ? schema.getDescription() : "");
        apiResponse.setDescription(string);
        apiResponses.addApiResponse("200", apiResponse);
    }

    @Nonnull
    private io.swagger.v3.oas.models.responses.ApiResponses a(Operation operation) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new io.swagger.v3.oas.models.responses.ApiResponses();
            operation.setResponses(apiResponses);
        }
        return apiResponses;
    }

    private void b(@Nonnull Operation operation, @Nonnull RequestHandlerBase<?, ?> requestHandlerBase, @Nonnull Components components) {
        Type type = requestHandlerBase.getInputType();
        if (type == null) {
            return;
        }
        RequestBody requestBody = operation.getRequestBody() != null ? operation.getRequestBody() : new RequestBody();
        Content content = requestBody.getContent() != null ? requestBody.getContent() : new Content();
        MediaType mediaType = (MediaType)content.getOrDefault((Object)"application/json; charset=utf-8", (Object)new MediaType());
        if (mediaType.getSchema() != null) {
            return;
        }
        mediaType.setSchema(c.b(components).a(type));
        Schema schema = (Schema)components.getSchemas().get(c.f(type.getTypeName()));
        if (schema != null) {
            requestBody.setDescription(a.e(schema.getDescription()));
        }
        content.addMediaType("application/json; charset=utf-8", mediaType);
        requestBody.setContent(content);
        operation.setRequestBody(requestBody);
    }

    private void a(@Nonnull PathItem pathItem, @Nonnull Operation operation, @Nonnull String string) {
        switch (string.toUpperCase()) {
            case "GET": {
                pathItem.get(operation);
                break;
            }
            case "PUT": {
                pathItem.put(operation);
                break;
            }
            case "DELETE": {
                pathItem.delete(operation);
                break;
            }
            case "HEAD": {
                pathItem.head(operation);
                break;
            }
            case "OPTIONS": {
                pathItem.options(operation);
                break;
            }
            case "PATCH": {
                pathItem.patch(operation);
                break;
            }
            default: {
                pathItem.post(operation);
            }
        }
    }

    @Nullable
    private Operation a(PathItem pathItem, String string) {
        switch (string.toUpperCase()) {
            case "GET": {
                return pathItem.getGet();
            }
            case "PUT": {
                return pathItem.getPost();
            }
            case "DELETE": {
                return pathItem.getDelete();
            }
            case "HEAD": {
                return pathItem.getHead();
            }
            case "OPTIONS": {
                return pathItem.getOptions();
            }
            case "PATCH": {
                return pathItem.getPatch();
            }
        }
        return pathItem.getPost();
    }

    private /* synthetic */ void a(String string, List list, OpenAPI openAPI, io.swagger.v3.oas.models.tags.Tag tag, RequestHandlerBase requestHandlerBase) {
        this.a(requestHandlerBase, string, list, openAPI, tag);
    }

    private static /* synthetic */ void a(io.swagger.v3.oas.models.parameters.Parameter parameter, String[] stringArray, PathInfo pathInfo) {
        parameter.setDescription(a.c(pathInfo.description(), parameter.getDescription()));
        stringArray[0] = a.c(pathInfo.path(), stringArray[0]);
    }

    private static /* synthetic */ void a(io.swagger.v3.oas.models.parameters.Parameter parameter, String string) {
        parameter.setDescription(string);
    }
}

