/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.help.api.HelpPageContentProcessor;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.SystemPermissionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpAdminBackdoor;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.webapi.api.APIHelpPageContentPatcher;
import com.inet.plugin.webapi.server.b;
import com.inet.plugin.webapi.server.c;
import com.inet.plugin.webapi.server.d;
import com.inet.plugin.webapi.structure.a;
import com.inet.remote.gui.IModule;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;

@PluginInfo(id="webapi.core", version="25.10.219", dependencies="", optionalDependencies="help;remotegui;theme", packages="com.inet.plugin.webapi.api;io.swagger.v3.oas.annotations", group="interfaces;webapi", flags="optional", internal="swagger-annotations.jar;swagger-models.jar", icon="com/inet/plugin/webapi/client/web_api_48.png")
public class WebAPICoreServerPlugin
implements ServerPlugin {
    public static final Permission PERMISSION_WEBAPI = SystemPermissionManager.add((String)"webapi.core", (String)"administration", null, (int)7790, (boolean)true, WebAPICoreServerPlugin.class);
    public static final I18nMessages MSG = new I18nMessages("com.inet.plugin.webapi.client.i18n.LanguageResources", WebAPICoreServerPlugin.class);
    public static final I18nMessages STRUCTURE = new I18nMessages("com.inet.plugin.webapi.structure.i18n.ConfigStructure", WebAPICoreServerPlugin.class);
    public static final Logger LOGGER = LogManager.getLogger((String)"Web API");

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("webapi.core", 9202, new Permission[]{PERMISSION_WEBAPI}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                boolean bl = super.isVisible(helpPage);
                if (!bl) {
                    return bl;
                }
                switch (helpPage.getKey()) {
                    case "webapi.core.searchtags": {
                        return false;
                    }
                    case "usersandgroups.permissions": {
                        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
                    }
                }
                return true;
            }
        }, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("configuration", 9997, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
        ServerPluginManager.getInstance().runIfPluginLoaded("help", () -> new Executable(){

            public void execute() {
                HelpPageContentProcessor.register((HelpPageContentProcessor)new com.inet.plugin.webapi.server.data.a());
            }
        });
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (spm.isPluginLoaded("remotegui")) {
            new Executable(){

                public void execute() {
                    spm.register(ConfigStructureProvider.class, (Object)new a());
                    final c c2 = new c();
                    spm.register(IModule.class, (Object)new b());
                    spm.register(PluginServlet.class, (Object)c2);
                    c2.addServiceMethod(new com.inet.plugin.webapi.server.handler.a());
                    c2.addServiceMethod(new com.inet.plugin.webapi.server.handler.c());
                    spm.runIfPluginLoaded("help", () -> new Executable(){

                        public void execute() {
                            c2.addServiceMethod(new com.inet.plugin.webapi.server.handler.b());
                        }
                    });
                    final Class<?> clazz = ((Object)((Object)this)).getClass();
                    FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.add(clazz, "client/shared.factory.js");
                    combinedFile.add(clazz, "client/webapi.core.editor.js");
                    combinedFile.add(clazz, "client/webapi.core.js");
                    combinedFile.addMessages(MSG);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 1, "webapi.core.js", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.addRuntimeData(new FileCombiner.RuntimeData(){

                        public InputStream getDataStream() {
                            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
                            if (httpServletRequest == null) {
                                return null;
                            }
                            String string = httpServletRequest.getParameter("mode");
                            if ("webapi.core.request".equals(string)) {
                                return clazz.getResourceAsStream("client/webapi.codemirror.js");
                            }
                            return null;
                        }
                    });
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "codemirror.mode.js", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
                    combinedFile.add(clazz, "client/css/webapi.css");
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile));
                    if (spm.isPluginLoaded("theme")) {
                        spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", clazz.getResource("client/css/webapi.less")));
                    }
                }
            }.execute();
        } else {
            spm.register(PluginServlet.class, (Object)d.c());
        }
        if (ServerPluginManager.DEBUG) {
            spm.register(HttpSessionListener.class, (Object)new HttpSessionListener(){

                public void sessionCreated(HttpSessionEvent se) {
                    LoginProcessor loginProcessor;
                    String string;
                    HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
                    String string2 = string = httpServletRequest == null ? "" : httpServletRequest.getServletPath();
                    if ((string.startsWith("/api/") || string.equals("/api")) && ((loginProcessor = LoginProcessor.getCurrent()) == null || LoginManager.isTokenLoginSource((String)loginProcessor.getLoginSource()))) {
                        LOGGER.error((Throwable)new Exception("Session created from webapi"));
                    }
                }
            });
        }
    }

    public void init(final ServerPluginManager spm) {
        ServerPluginManager.getInstance().runIfPluginLoaded("help", () -> new Executable(){

            public void execute() {
                HelpAdminBackdoor helpAdminBackdoor = (HelpAdminBackdoor)spm.getSingleInstance(HelpAdminBackdoor.class);
                APIHelpPageContentPatcher aPIHelpPageContentPatcher = new APIHelpPageContentPatcher(helpAdminBackdoor);
                d.c().a(aPIHelpPageContentPatcher);
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }
}

