/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.api.handler;

import com.inet.annotations.InternalApi;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="List available search tags for the current context. These can be used with the main handler to query elements", summary="List of available search tags.")
@InternalApi
public class AvailableSearchTags
extends RequestHandlerBase<Void, Map<String, String>> {
    private Supplier<IndexSearchEngine<?>> h;

    public AvailableSearchTags(Supplier<IndexSearchEngine<?>> engineSupplier) {
        super(".search");
        this.h = engineSupplier;
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.core.searchtags";
    }

    @Override
    @Operation(summary="List of available search tags", description="Retrieves a list search tags, listing them with their key and display name.")
    public Map<String, String> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Void inputObject, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        IndexSearchEngine<?> indexSearchEngine = this.h.get();
        Objects.requireNonNull(indexSearchEngine);
        return indexSearchEngine.getTags().stream().collect(Collectors.toMap(SearchTag::getTag, SearchTag::getDisplayName));
    }
}

