/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.api;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AccessForbiddenException;
import com.inet.http.ClientMessageException;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonWriterFilter;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.plugin.webapi.WebAPICoreServerPlugin;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

@InternalApi
public class ResponseWriter {
    public static void notFound(HttpServletResponse response) {
        response.setStatus(404);
        response.setContentType("application/json; charset=utf-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    public static void notFound(HttpServletResponse response, String messageComponent) {
        ResponseWriter.notFound(response);
        throw new ClientMessageException(WebAPICoreServerPlugin.MSG.getMsg("response.notFound", new Object[]{StringFunctions.isEmpty((String)messageComponent) ? 0 : 1, messageComponent}));
    }

    public static void forbidden(HttpServletResponse response) {
        response.setStatus(403);
        response.setContentType("application/json; charset=utf-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    public static void forbidden(HttpServletResponse response, @Nonnull Permission requiredPermission) {
        ResponseWriter.forbidden(response);
        throw new AccessDeniedException(requiredPermission);
    }

    public static void forbidden(HttpServletResponse response, @Nonnull String message) {
        ResponseWriter.forbidden(response);
        throw new AccessForbiddenException(message);
    }

    public static void html(HttpServletResponse response, String html) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html; charset=utf-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getOutputStream().write(html.getBytes(StandardCharsets.UTF_8));
    }

    public static void json(HttpServletResponse response, Object input) throws IOException {
        ResponseWriter.json(response, input, 200);
    }

    public static void json(HttpServletResponse response, Object input, int status) throws IOException {
        ResponseWriter.json(response, input, status, null);
    }

    public static void json(HttpServletResponse response, Object input, int status, JsonWriterFilter filter) throws IOException {
        ResponseWriter.json(response, input, status, filter, (Appendable)new UTF8StreamWriter((OutputStream)response.getOutputStream()));
    }

    public static void json(@Nonnull HttpServletResponse response, Object input, int status, JsonWriterFilter filter, @Nonnull Appendable streamWriter) throws IOException {
        if (status > 0) {
            response.setStatus(status);
        }
        response.setContentType("application/json; charset=utf-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        new Json().toJson(input, streamWriter, filter);
    }

    public static void ok(HttpServletResponse response) {
        response.setStatus(200);
        response.setContentType("application/json; charset=utf-8");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    public static void unavailable(HttpServletResponse response) {
        response.setStatus(503);
    }
}

