/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.webapi.api;

import com.inet.annotations.InternalApi;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class PathTokenizer {
    public static List<String> convertPathToTokens(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        if ((path = path.replaceAll("/+", "/").trim()).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("swagger.json")) {
            path = path.substring(0, path.length() - "swagger.json".length());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : path.split("/")) {
            if (string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> originalTokensFor(String path, @Nonnull List<String> pathTokens) {
        List<String> list = PathTokenizer.convertPathToTokens(path);
        if (pathTokens.size() > list.size()) {
            return pathTokens;
        }
        return list.subList(list.size() - pathTokens.size(), list.size());
    }
}

