/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.users;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroupsmanager.server.webapi.users.UserIDRequestData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="User details response with optional additional fields that have to be requested specifically.", title="User Details Response", example="{\"id\":\"000aIG6b0IaRVqazNR3j6Jelg\",\"type\":\"USER\",\"displayName\":\"John Doe\",\"lastAccess\":1234567890,\"fields\":{\"email\":\"john@example.com\",\"loginId\":\"jdoe\"},\"availableFields\":[\"email\",\"loginId\",\"phone\"]}")
public class UserIDResponseData {
    @Schema(description="The GUID of the user", example="000aIG6b0IaRVqazNR3j6Jelg", required=true)
    private String id;
    @Schema(description="The type of user account", example="USER", required=true)
    private String type;
    @Schema(description="The display name of the user", example="John Doe", required=true)
    private String displayName;
    @Schema(description="Timestamp of the user's last access", example="1234567890", required=true)
    private long lastAccess;
    @Schema(description="Additional user fields that were specifically requested", example="{\"email\":\"john@example.com\",\"loginId\":\"jdoe\"}", required=false)
    @JsonExcludeNull
    private Map<String, Object> fields;
    @Schema(description="List of field names that can be requested for this user. Only returned when the query has an empty fields list.", example="[\"email\",\"loginId\",\"phone\"]", required=false)
    @JsonExcludeNull
    @Description(description="An optional list of field names that can be requested for this type. Will be returned only, when the query has a `fields = []` property.")
    private List<@Nonnull String> availableFields;

    public static UserIDResponseData from(UserAccount userAccount, UserIDRequestData requestedFields) {
        UserIDResponseData userIDResponseData = new UserIDResponseData();
        userIDResponseData.displayName = userAccount.getDisplayName();
        userIDResponseData.lastAccess = userAccount.getLastAccess();
        userIDResponseData.type = userAccount.getAccountType().name();
        Set set = userAccount.getIncludedFields();
        set.removeIf(f2 -> !UserField.includeInTextSearchDependingOnFieldAvailability((String)f2.getKey()).getAsBoolean());
        if (requestedFields != null && !requestedFields.getFields().isEmpty()) {
            List<String> list = requestedFields.getFields();
            set.removeIf(f2 -> !list.contains(f2.getKey()));
            for (UserField userField : set) {
                userIDResponseData.addField(userField.getKey(), userAccount.getValue(userField));
            }
        } else if (requestedFields != null) {
            userIDResponseData.availableFields = set.stream().map(f2 -> f2.getKey()).collect(Collectors.toList());
        }
        return userIDResponseData;
    }

    private void addField(String key, Object value) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(key, value);
    }
}

