/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.handler;

import com.inet.config.ConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.filter.UserOrGroupFilter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.UsersAndGroupsManagerServerPlugin;
import com.inet.usersandgroupsmanager.server.data.FilterDescription;
import com.inet.usersandgroupsmanager.server.data.GroupTypeDescription;
import com.inet.usersandgroupsmanager.server.data.Grouping;
import com.inet.usersandgroupsmanager.server.data.InitDataRequestData;
import com.inet.usersandgroupsmanager.server.data.InitDataResponseData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class i
extends ServiceMethod<InitDataRequestData, InitDataResponseData> {
    private static final ConfigValue<Boolean> q = new ConfigValue(UsersAndGroupsManagerServerPlugin.CONFIGKEY_DELETE_USERS_IN_MANAGER);

    public String getMethodName() {
        return "usersandgroupsmanager_initdata";
    }

    public short getMethodType() {
        return 1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public InitDataResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, InitDataRequestData initDataRequestData) throws IOException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notloggedin", new Object[0]));
        }
        if (!(initDataRequestData != null && initDataRequestData.isPreventInitialCheck() || SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER))) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.nopermission", new Object[0]));
        }
        HashMap<Grouping, GroupTypeDescription> hashMap = new HashMap<Grouping, GroupTypeDescription>();
        @Nonnull List list = ServerPluginManager.getInstance().get(GroupTypeDef.class);
        for (GroupTypeDef groupTypeDef : list) {
            GroupTypeDescription groupTypeDescription = new GroupTypeDescription(groupTypeDef);
            hashMap.put(new Grouping(Type.group, groupTypeDef.getGroupType().getName()), groupTypeDescription);
        }
        for (UserAccountType userAccountType : UserAccountType.values()) {
            if (userAccountType == UserAccountType.Temp) continue;
            GroupTypeDescription groupTypeDescription = new GroupTypeDescription(userAccountType);
            hashMap.put(new Grouping(Type.user, userAccountType.name()), groupTypeDescription);
        }
        String string = UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.useraccounttype.locked", new Object[0]);
        hashMap.put(new Grouping(Type.user, "locked"), new GroupTypeDescription(UserAccountType.values().length, string, string, UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.useraccounttype.locked.description", new Object[0]), true, null, null, false, false, true));
        String string2 = UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.useraccounttype.inactive", new Object[0]);
        hashMap.put(new Grouping(Type.user, "inactive"), new GroupTypeDescription(UserAccountType.values().length + 1, string2, string2, UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.useraccounttype.inactive.description", new Object[0]), true, null, null, false, false, true));
        ArrayList<FilterDescription> arrayList = new ArrayList<FilterDescription>();
        @Nonnull List list2 = ServerPluginManager.getInstance().get(UserOrGroupFilter.class);
        list2.removeIf(userOrGroupFilter -> !userOrGroupFilter.isApplicable());
        list2.sort((userOrGroupFilter, userOrGroupFilter2) -> {
            if (userOrGroupFilter.getFilterType() == Type.user) {
                if (userOrGroupFilter2.getFilterType() == Type.user) {
                    if (userOrGroupFilter.getExtensionName().equals("allusers")) {
                        return -1;
                    }
                    if (userOrGroupFilter2.getExtensionName().equals("allusers")) {
                        return 1;
                    }
                    return userOrGroupFilter.getPriority() - userOrGroupFilter2.getPriority();
                }
                return -1;
            }
            if (userOrGroupFilter.getFilterType() == Type.group) {
                if (userOrGroupFilter2.getFilterType() == Type.group) {
                    if (userOrGroupFilter.getExtensionName().equals("allgroups")) {
                        return -1;
                    }
                    if (userOrGroupFilter2.getExtensionName().equals("allgroups")) {
                        return 1;
                    }
                    return userOrGroupFilter.getPriority() - userOrGroupFilter2.getPriority();
                }
                return 1;
            }
            return 0;
        });
        for (GroupTypeDescription groupTypeDescription : list2) {
            if (!groupTypeDescription.isApplicable()) continue;
            arrayList.add(new FilterDescription(groupTypeDescription.getExtensionName(), groupTypeDescription.getDisplayName(), groupTypeDescription.getFilterType()));
        }
        String string3 = (String)userAccount.getValue(UsersAndGroupsManagerServerPlugin.USERFIELD_USERANDGROUPSLASTFILTER);
        return new InitDataResponseData(hashMap, arrayList, string3, (Boolean)q.get(), SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN));
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (InitDataRequestData)object);
    }
}

