/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.users;

import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.AvailableSearchTags;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.server.webapi.users.UsersListRequestData;
import com.inet.usersandgroupsmanager.server.webapi.users.UsersListResponseData;
import com.inet.usersandgroupsmanager.server.webapi.users.a;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="List available users and allow searching for them using a query.", summary="List of available users.")
@Tag(name="Users", description="User management and search operations")
public class b
extends RequestHandlerBase<UsersListRequestData, UsersListResponseData> {
    public b() {
        super(new String[]{"users"});
        this.setGenericRequestHandler((RequestHandler)new a());
        this.registerRequestHandler((RequestHandlerBase)new AvailableSearchTags(() -> UserManager.getRecoveryEnabledInstance().getSearchEngine()));
    }

    public String getHelpPageKey() {
        return "usersandgroups.webapi.users";
    }

    @Operation(summary="List and search users", description="Retrieves a list of users, optionally filtered by a search query. The search query supports the same syntax as the Users and Groups application. Maximum of 5000 entries are returned.", responses={@ApiResponse(responseCode="200", description="Successfully retrieved list of users", content={@Content(schema=@Schema(implementation=UsersListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search query format")})
    public UsersListResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable UsersListRequestData usersListRequestData, @Nonnull List<String> list, boolean bl) throws IOException {
        String string = "";
        if (usersListRequestData != null && !StringFunctions.isEmpty((String)usersListRequestData.getQuery())) {
            string = usersListRequestData.getQuery();
        }
        SearchID searchID = new SearchID((Object)(this.getName() + "_" + httpServletRequest.getSession().getId() + "_" + string));
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        ArrayList arrayList = new ArrayList();
        ArrayList<SearchCondition> arrayList2 = new ArrayList<SearchCondition>();
        arrayList2.add(new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        SearchResult searchResult = userManager.searchAsUser(string, arrayList2, arrayList, 10000, searchID);
        return UsersListResponseData.from(searchResult.getEntries());
    }

    @Operation(summary="List and search users", description="Retrieves a list of users, optionally filtered by a search query. The search query supports the same syntax as the Users and Groups application. Maximum of 5000 entries are returned.", responses={@ApiResponse(responseCode="200", description="Successfully retrieved list of users", content={@Content(schema=@Schema(implementation=UsersListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search query format")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, @Nonnull List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (UsersListRequestData)object, list, bl);
    }
}

