/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.handler;

import com.inet.http.ClientMessageException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.PermissionDescription;
import com.inet.usersandgroups.api.ui.fields.user.PermissionDefinitionHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.UsersAndGroupsManagerServerPlugin;
import com.inet.usersandgroupsmanager.server.data.EffectivePermissionSource;
import com.inet.usersandgroupsmanager.server.data.EffectivePermissionsRequestData;
import com.inet.usersandgroupsmanager.server.data.EffectivePermissionsResponseData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class c
extends ServiceMethod<EffectivePermissionsRequestData, EffectivePermissionsResponseData> {
    public String getMethodName() {
        return "usersandgroupsmanager_effectivepermissions";
    }

    public short getMethodType() {
        return 1;
    }

    public EffectivePermissionsResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, EffectivePermissionsRequestData effectivePermissionsRequestData) throws IOException {
        Object object;
        Hash hash = effectivePermissionsRequestData.getHash();
        if (hash.getType() == Type.group) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.accessdenied", new Object[0]));
        }
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            throw new ClientMessageException(UsersAndGroupsManagerServerPlugin.MSG.getMsg("usersandgroupsmanager.notfound.user", new Object[0]));
        }
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        UserAccount userAccount = userManager.getUserAccount(hash.getId());
        if (userAccount == null) {
            return null;
        }
        String string = !userAccount.isActive() ? ((object = (String)userAccount.getValue(userManager.getField("blockingnotice"))) != null ? "locked" : "inactive") : userAccount.getAccountType().name();
        object = userAccount.getPermissions();
        UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
        Set set = userGroupManager.getGroupsForUser(hash.getId());
        ArrayList arrayList = new ArrayList();
        ArrayList<PermissionDescription> arrayList2 = new ArrayList<PermissionDescription>();
        PermissionDefinitionHelper.createPermissionDefinition((Set)object, (String)string, arrayList2, arrayList);
        HashMap<String, ArrayList<EffectivePermissionSource>> hashMap = new HashMap<String, ArrayList<EffectivePermissionSource>>();
        this.a(hash, userAccount.getDisplayName(), (Set<Permission>)object, hashMap);
        for (UserGroupInfo userGroupInfo : set) {
            Hash hash2 = new Hash(Type.group, userGroupInfo.getID());
            this.a(hash2, userGroupInfo, hashMap);
        }
        EffectivePermissionsResponseData effectivePermissionsResponseData = new EffectivePermissionsResponseData(arrayList2);
        effectivePermissionsResponseData.setEffectivePermissions(hashMap);
        return effectivePermissionsResponseData;
    }

    private void a(Hash hash, UserGroupInfo userGroupInfo, HashMap<String, ArrayList<EffectivePermissionSource>> hashMap) {
        Set set = userGroupInfo.getPermissions();
        if (userGroupInfo.getType() != null && userGroupInfo.getType().equals((Object)UsersAndGroups.GROUPTYPE_ADMIN)) {
            this.a(hash, userGroupInfo.getDisplayName(), new HashSet<Permission>(Arrays.asList(Permission.values())), hashMap);
        } else {
            this.a(hash, userGroupInfo.getDisplayName(), set, hashMap);
        }
    }

    private void a(Hash hash, String string, Set<Permission> set, HashMap<String, ArrayList<EffectivePermissionSource>> hashMap) {
        Set set2 = set.stream().map(permission -> permission.getKey()).collect(Collectors.toSet());
        set = set.stream().filter(permission -> permission.getParentKey() == null || permission.getParentKey() != null && set2.contains(permission.getParentKey())).collect(Collectors.toSet());
        for (Permission permission2 : set) {
            ArrayList<EffectivePermissionSource> arrayList;
            EffectivePermissionSource effectivePermissionSource = new EffectivePermissionSource(hash, string);
            if (permission2.getParentKey() != null && permission2.getParentKey().length() > 0) {
                effectivePermissionSource.setParentKey(permission2.getParentKey());
            }
            if ((arrayList = hashMap.get(permission2.getKey())) == null) {
                arrayList = new ArrayList();
                hashMap.put(permission2.getKey(), arrayList);
            }
            arrayList.add(effectivePermissionSource);
        }
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (EffectivePermissionsRequestData)object);
    }
}

