/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroupsmanager.server.webapi.groups;

import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.AvailableSearchTags;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroupsmanager.server.webapi.groups.GroupsListRequestData;
import com.inet.usersandgroupsmanager.server.webapi.groups.GroupsListResponseData;
import com.inet.usersandgroupsmanager.server.webapi.groups.a;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="List available groups and allow searching for them using a query.", summary="List of available groups.")
@Tag(name="Groups", description="Group management and search operations")
public class b
extends RequestHandlerBase<GroupsListRequestData, GroupsListResponseData> {
    public b() {
        super(new String[]{"groups"});
        this.setGenericRequestHandler((RequestHandler)new a());
        this.registerRequestHandler((RequestHandlerBase)new AvailableSearchTags(() -> UserGroupManager.getRecoveryEnabledInstance().getSearchEngine()));
    }

    public String getHelpPageKey() {
        return "usersandgroups.webapi.groups";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Operation(summary="List and search groups", description="Retrieves a list of groups, optionally filtered by a search query. The search query supports the same syntax as the Users and Groups application. Maximum of 5000 entries are returned. Only groups of registered group types will be returned.", responses={@ApiResponse(responseCode="200", description="Successfully retrieved list of groups", content={@Content(schema=@Schema(implementation=GroupsListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search query format")})
    public GroupsListResponseData a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable GroupsListRequestData groupsListRequestData, @Nonnull List<String> list, boolean bl) throws IOException {
        String string = "";
        if (groupsListRequestData != null && !StringFunctions.isEmpty((String)groupsListRequestData.getQuery())) {
            string = groupsListRequestData.getQuery();
        }
        @Nonnull List list2 = ServerPluginManager.getInstance().get(GroupTypeDef.class);
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        list2.forEach(groupTypeDef -> orSearchExpression.add((Object)new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, (Object)groupTypeDef.getGroupType().getName())));
        SearchID searchID = new SearchID((Object)(this.getName() + "_" + httpServletRequest.getSession().getId() + "_" + string));
        UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
        HashSet<SearchTag> hashSet = new HashSet<SearchTag>(userGroupManager.getSearchEngine().getTags());
        hashSet.removeIf(searchTag -> !searchTag.isSuggestedTag());
        ArrayList<TokenMatcher> arrayList = new ArrayList<TokenMatcher>();
        List list3 = userGroupManager.getSearchEngine().getTokenMatcher();
        if (list3 != null) {
            arrayList.addAll(list3);
        }
        arrayList.removeIf(tokenMatcher -> !tokenMatcher.isSuggestedTag());
        ArrayList arrayList2 = new ArrayList();
        ArrayList<OrSearchExpression> arrayList3 = new ArrayList<OrSearchExpression>();
        arrayList3.add(orSearchExpression);
        SearchResult searchResult = userGroupManager.search(string, arrayList3, arrayList2, 10000, searchID, hashSet, arrayList);
        return GroupsListResponseData.from(searchResult.getEntries());
    }

    @Operation(summary="List and search groups", description="Retrieves a list of groups, optionally filtered by a search query. The search query supports the same syntax as the Users and Groups application. Maximum of 5000 entries are returned. Only groups of registered group types will be returned.", responses={@ApiResponse(responseCode="200", description="Successfully retrieved list of groups", content={@Content(schema=@Schema(implementation=GroupsListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search query format")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, @Nonnull List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (GroupsListRequestData)object, list, bl);
    }
}

