/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.schema;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.data.base.SCIMMultiValue;
import com.inet.plugin.scim.webapi.data.base.types.a;
import com.inet.plugin.scim.webapi.data.base.types.b;
import com.inet.plugin.scim.webapi.data.base.types.c;
import com.inet.plugin.scim.webapi.data.base.types.d;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SchemaAttribute {
    @ScimAttribute(description="The attribute's name")
    private String name;
    @ScimAttribute(description="The attribute's description")
    private String description;
    @ScimAttribute(description="The attribute's data type")
    private String type;
    @JsonExcludeNull
    @ScimAttribute(description="Sub-attributes of the attribute", required=false, multiValued=true)
    private List<SchemaAttribute> subAttributes;
    @ScimAttribute(description="Indicates if the attribute is multi-valued")
    private boolean multiValued;
    @ScimAttribute(description="Indicates if the attribute is required")
    private boolean required;
    @JsonExcludeNull
    @ScimAttribute(description="A list of canonical values for the attribute", required=false, multiValued=true)
    private List<String> canonicalValues;
    @ScimAttribute(description="Indicates if the attribute is case exact")
    private boolean caseExact;
    @ScimAttribute(description="The mutability of the attribute")
    private a mutability;
    @ScimAttribute(description="The returnability of the attribute")
    private String returned;
    @ScimAttribute(description="The uniqueness of the attribute")
    private d uniqueness;
    @JsonExcludeNull
    @ScimAttribute(description="A list of reference types for the attribute", required=false, multiValued=true)
    private List<@Nonnull SCIMMultiValue> referenceTypes;

    public String getName() {
        return this.name;
    }

    public b getReturned() {
        return b.d(this.returned);
    }

    @Nullable
    public List<SchemaAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    public static SchemaAttribute from(Field field) {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        schemaAttribute.name = field.getName();
        c c2 = c.a(field);
        schemaAttribute.type = c2.toString();
        ScimAttribute scimAttribute = field.getAnnotation(ScimAttribute.class);
        if (scimAttribute == null) {
            return schemaAttribute;
        }
        schemaAttribute.description = scimAttribute.description();
        schemaAttribute.multiValued = scimAttribute.multiValued();
        schemaAttribute.mutability = scimAttribute.mutability();
        schemaAttribute.uniqueness = scimAttribute.uniqueness();
        schemaAttribute.required = scimAttribute.required();
        schemaAttribute.returned = scimAttribute.returned().toString();
        ArrayList<String> arrayList = new ArrayList<String>(List.of(scimAttribute.canonicalValues().split("[;,\\s]")));
        arrayList.removeIf(e -> StringFunctions.isEmpty((String)e));
        if (arrayList.size() > 0) {
            schemaAttribute.canonicalValues = arrayList;
        }
        if (c.I == c2) {
            List<String> list = List.of(scimAttribute.referenceTypes().split("[;,\\s]"));
            List<@Nonnull T> list2 = list.stream().filter(r -> !StringFunctions.isEmpty((String)r)).map(r -> new SCIMMultiValue((String)r)).collect(Collectors.toList());
            if (list2.size() > 0) {
                schemaAttribute.referenceTypes = list2;
            }
        } else if (c.J == c2) {
            if (schemaAttribute.subAttributes == null) {
                schemaAttribute.subAttributes = new ArrayList<SchemaAttribute>();
            }
            for (Field field2 : field.getType().getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                schemaAttribute.subAttributes.add(SchemaAttribute.from(field2));
            }
            schemaAttribute.subAttributes.removeIf(e -> e == null);
            if (schemaAttribute.subAttributes.isEmpty()) {
                schemaAttribute.subAttributes = null;
            }
        }
        return schemaAttribute;
    }
}

