/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.user;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.b;
import com.inet.plugin.scim.webapi.data.base.SCIMMultiValue;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.base.types.d;
import com.inet.plugin.scim.webapi.data.user.UserAddress;
import com.inet.plugin.scim.webapi.data.user.UserGroup;
import com.inet.plugin.scim.webapi.data.user.UserName;
import com.inet.plugin.scim.webapi.data.user.a;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@ScimSchema(name="User", description="User Account", schema="urn:ietf:params:scim:schemas:core:2.0:User", endpoint="/Users")
@JsonData
public class UserResource
extends SCIMSchema.SCIMBasicAttributes
implements a {
    public static final UserField<String> FIELD_USERNAME = new UserField<String>("scim_username"){};
    @ScimAttribute(description="Unique identifier for the User", uniqueness=d.server, caseExact=true)
    private String userName;
    @ScimAttribute(description="The components of the user's real name.", required=false)
    private UserName name;
    @JsonExcludeNull
    @ScimAttribute(description="The name of the User, suitable for display to end-users.", required=false)
    private String displayName;
    @JsonExcludeNull
    @ScimAttribute(description="The casual way to address the user in real life", required=false)
    private String nickName;
    @JsonExcludeNull
    @ScimAttribute(description="The URI that points to a location representing the user's online profile", required=false)
    private String profileURL;
    @JsonExcludeNull
    @ScimAttribute(description="The user's title", required=false)
    private String title;
    @JsonExcludeNull
    @ScimAttribute(description="The type of user (e.g., 'Employee', 'Contractor')", required=false)
    private String userType;
    @JsonExcludeNull
    @ScimAttribute(description="The user's preferred language", required=false)
    private String preferredLanguage;
    @JsonExcludeNull
    @ScimAttribute(description="The user's locale", required=false)
    private String locale;
    @JsonExcludeNull
    @ScimAttribute(description="The user's timezone", required=false)
    private String timezone;
    @JsonExcludeNull
    @ScimAttribute(description="A Boolean value indicating the user's administrative status", required=false)
    private Boolean active;
    @JsonExcludeNull
    @ScimAttribute(description="The user's clear text password", required=false, mutability=com.inet.plugin.scim.webapi.data.base.types.a.writeOnly, returned=com.inet.plugin.scim.webapi.data.base.types.b.Never)
    private transient String password;
    @JsonExcludeNull
    @ScimAttribute(description="Email addresses for the user", multiValued=true, required=false)
    private List<SCIMMultiValue> emails;
    @JsonExcludeNull
    @ScimAttribute(description="Phone numbers for the user", multiValued=true, required=false)
    private List<SCIMMultiValue> phoneNumbers;
    @JsonExcludeNull
    @ScimAttribute(description="Instant messaging addresses for the user", multiValued=true, required=false)
    private List<String> ims;
    @JsonExcludeNull
    @ScimAttribute(description="URLs of photos of the user", multiValued=true, required=false)
    private List<SCIMMultiValue> photos;
    @JsonExcludeNull
    @ScimAttribute(description="Physical addresses for the user", multiValued=true, required=false)
    private List<UserAddress> addresses;
    @JsonExcludeNull
    @ScimAttribute(description="Groups that the user is a member of", multiValued=true, required=false, mutability=com.inet.plugin.scim.webapi.data.base.types.a.readOnly)
    private List<UserGroup> groups;
    @JsonExcludeNull
    @ScimAttribute(description="Entitlements for the user", multiValued=true, required=false)
    private List<String> entitlements;
    @JsonExcludeNull
    @ScimAttribute(description="Roles for the user", multiValued=true, required=false)
    private List<String> roles;
    @JsonExcludeNull
    @ScimAttribute(description="Certificates for the user", multiValued=true, required=false)
    private List<String> x509Certificates;

    public static UserResource fromUser(UserAccount account) {
        String string;
        Object object;
        Object object2;
        UserResource userResource = new UserResource();
        userResource.meta.addLocationId(account.getID().toString());
        userResource.meta.setLastModified(account.getLastModified());
        userResource.id = account.getID().toString();
        userResource.externalId = account.getID().toString();
        LoginSettings loginSettings = account.getLoginSettingsFor("system").stream().findFirst().orElse(null);
        userResource.userName = loginSettings != null ? loginSettings.getLoginID() : account.getID().toString();
        userResource.displayName = account.getDisplayName();
        userResource.name = UserName.from(account);
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            object2 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest)) + ProxyHttpServletRequest.getContextPath((HttpServletRequest)httpServletRequest);
            userResource.profileURL = (String)object2 + "/usersandgroups/user/" + userResource.id;
            String string2 = (String)object2 + "/usersandgroups/?method=usersandgroupsmanager_geticon&hash=";
            string2 = string2 + EncodingFunctions.encodeUrlParameter((String)("user\n" + account.getID().toString()));
            userResource.photos = List.of(new SCIMMultiValue(string2, "photo", null, null));
        }
        userResource.active = account.isActive();
        object2 = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        if (!StringFunctions.isEmpty((String)object2)) {
            userResource.emails = new ArrayList<SCIMMultiValue>();
            int n = 0;
            object = ((String)object2).split("[,; ]");
            int n2 = ((String[])object).length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = object[i];
                if (StringFunctions.isEmpty((String)object3)) continue;
                Boolean bl = n++ == 0 ? Boolean.TRUE : null;
                userResource.emails.add(new SCIMMultiValue((String)object3, "work", bl, null));
            }
        }
        if (!StringFunctions.isEmpty((String)(string = (String)account.getValue((UserField)UsersAndGroups.FIELD_TELEPHONE)))) {
            userResource.phoneNumbers = List.of(new SCIMMultiValue(string, "office", Boolean.TRUE, null));
        }
        if ((object = UserGroupManager.getInstance().getGroupsForUser(account.getID())).size() > 0) {
            userResource.groups = new ArrayList<UserGroup>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                UserGroupInfo userGroupInfo = (UserGroupInfo)iterator.next();
                userResource.groups.add(UserGroup.from(userGroupInfo));
            }
        }
        return userResource;
    }

    @Override
    public MutableUserData getMutableUserData() {
        String string;
        MutableUserData mutableUserData = new MutableUserData();
        if (this.name != null) {
            b.a(mutableUserData, this.name.getMutableUserData());
        }
        if (this.emails != null && !StringFunctions.isEmpty((String)(string = this.emails.stream().map(p -> p.getValue()).collect(Collectors.joining(";"))))) {
            mutableUserData.put((UserField)UsersAndGroups.FIELD_EMAIL, (Object)string);
        }
        if (this.phoneNumbers != null && !StringFunctions.isEmpty((String)(string = this.phoneNumbers.stream().map(p -> p.getValue()).collect(Collectors.joining(", "))))) {
            mutableUserData.put((UserField)UsersAndGroups.FIELD_TELEPHONE, (Object)string);
        }
        mutableUserData.put(FIELD_USERNAME, (Object)this.userName);
        return mutableUserData;
    }

    private UserResource() {
    }
}

