/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.user;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.annotations.ScimSchemaExtension;
import com.inet.plugin.scim.webapi.b;
import com.inet.plugin.scim.webapi.data.base.SCIMMultiValue;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.user.a;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.SQLException;

@JsonData
@ScimSchema(name="EnterpriseUser", schema="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
@ScimSchemaExtension
public class EnterpriseUserResource
extends SCIMSchema
implements a {
    @JsonExcludeNull
    @ScimAttribute(description="Numeric or alphanumeric identifier assigned to a person, typically based on order of hire or association with an organization", required=false)
    private String employeeNumber;
    @JsonExcludeNull
    @ScimAttribute(description="Identifies the name of a cost center", required=false)
    private String costCenter;
    @JsonExcludeNull
    @ScimAttribute(description="Identifies the name of an organization", required=false)
    private String organization;
    @JsonExcludeNull
    @ScimAttribute(description="Identifies the name of a division", required=false)
    private String division;
    @JsonExcludeNull
    @ScimAttribute(description="Identifies the name of a department", required=false)
    private String department;
    @JsonExcludeNull
    @ScimAttribute(description="The user's manager", required=false)
    private SCIMMultiValue manager;

    private EnterpriseUserResource() {
    }

    public static EnterpriseUserResource fromUser(final UserAccount account) {
        final EnterpriseUserResource enterpriseUserResource = new EnterpriseUserResource();
        ServerPluginManager.getInstance().runIfPluginLoaded("helpdesk", () -> new Executable(){

            public void execute() {
                enterpriseUserResource.costCenter = b.a((String)account.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE));
                LocationVO locationVO = (LocationVO)LocationManager.getInstance().get(((Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)).intValue());
                enterpriseUserResource.organization = b.a(locationVO.getDisplayValue());
                enterpriseUserResource.department = b.a((String)account.getValue(UsersAndGroups.getFieldByKey((String)"department")));
                enterpriseUserResource.division = b.a((String)account.getValue((UserField)HDUsersAndGroups.FIELD_ROOM));
            }
        });
        return enterpriseUserResource;
    }

    @Override
    public MutableUserData getMutableUserData() {
        final MutableUserData mutableUserData = new MutableUserData();
        ServerPluginManager.getInstance().runIfPluginLoaded("helpdesk", () -> new Executable(){

            public void execute() {
                b.a(mutableUserData, (UserField<String>)HDUsersAndGroups.FIELD_COST_CENTRE, EnterpriseUserResource.this.costCenter);
                LocationVO locationVO = (LocationVO)LocationManager.getInstance().getByDisplayName(EnterpriseUserResource.this.organization, false);
                if (locationVO == null) {
                    try {
                        int n = LocationManager.getInstance().add((FieldVO)new LocationVO(-1, EnterpriseUserResource.this.organization, null, null, null, 0, false));
                        locationVO = (LocationVO)LocationManager.getInstance().get(n);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (locationVO != null) {
                    mutableUserData.putValidOrDefaultValueLazily((UserField)HDUsersAndGroups.FIELD_LOCATION_ID, (Object)locationVO.getId());
                }
                b.a(mutableUserData, (UserField<String>)UsersAndGroups.getFieldByKey((String)"department"), EnterpriseUserResource.this.department);
                b.a(mutableUserData, (UserField<String>)HDUsersAndGroups.FIELD_ROOM, EnterpriseUserResource.this.division);
            }
        });
        return mutableUserData;
    }
}

