/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.resource;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.annotations.ScimSchemaExtension;
import com.inet.plugin.scim.webapi.c;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@ScimSchema(name="ResourceType", description="Resource Types", schema="urn:ietf:params:scim:schemas:core:2.0:ResourceType", endpoint="/ResourceTypes")
@JsonData
public class ResourceTypeResponse
extends SCIMSchema.SCIMBasicAttributes {
    protected static final String SCIM_IDENTIFIER = "urn:ietf:params:scim:schemas:core:2.0:ResourceType";
    @ScimAttribute(description="A list of schemas suported", multiValued=true)
    private final List<String> schemas = List.of("urn:ietf:params:scim:schemas:core:2.0:ResourceType");
    @JsonExcludeNull
    @ScimAttribute(description="The resource type name", required=false)
    private String name;
    @JsonExcludeNull
    @ScimAttribute(description="The resource type description", required=false)
    private String description;
    @JsonExcludeNull
    @ScimAttribute(description="The resource type endpoint", required=false)
    private String endpoint;
    @JsonExcludeNull
    @ScimAttribute(description="The resource type schema", required=false)
    private String schema;
    @JsonExcludeNull
    @ScimAttribute(description="Schema extensions for the resource type", required=false, multiValued=true)
    private List<Extension> schemaExtensions;

    private ResourceTypeResponse() {
    }

    public ResourceTypeResponse(ScimSchema schema) {
        super(schema);
    }

    public static <T extends c<?>> ResourceTypeResponse from(T handler) {
        ScimSchema scimSchema = SCIMSchema.getSCIMSchemaForClass(handler.b());
        if (StringFunctions.isEmpty((String)scimSchema.endpoint())) {
            return null;
        }
        ResourceTypeResponse resourceTypeResponse = new ResourceTypeResponse(scimSchema);
        resourceTypeResponse.name = scimSchema.name();
        resourceTypeResponse.endpoint = scimSchema.endpoint();
        resourceTypeResponse.description = scimSchema.description();
        resourceTypeResponse.schema = handler.c();
        resourceTypeResponse.getMeta().updateLocation(resourceTypeResponse.getScimSchema().endpoint() + scimSchema.endpoint());
        for (Class<SCIMSchema> clazz : handler.a()) {
            ScimSchemaExtension scimSchemaExtension = clazz.getAnnotation(ScimSchemaExtension.class);
            ScimSchema scimSchema2 = clazz.getAnnotation(ScimSchema.class);
            if (scimSchemaExtension == null || scimSchema2 == null) continue;
            if (resourceTypeResponse.schemaExtensions == null) {
                resourceTypeResponse.schemaExtensions = new ArrayList<Extension>();
            }
            resourceTypeResponse.schemaExtensions.add(new Extension(scimSchema2.schema(), scimSchemaExtension.required()));
        }
        return resourceTypeResponse;
    }

    @JsonData
    public static class Extension {
        @ScimAttribute(description="The extension schema")
        private String schema;
        @ScimAttribute(description="True if the extension is required")
        private boolean required;

        public Extension(@Nonnull String schema, boolean required) {
            this.schema = schema;
            this.required = required;
        }
    }
}

