/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.provider;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.provider.AuthenticationScheme;
import java.util.ArrayList;
import java.util.List;

@ScimSchema(name="Service Provider Configuration", schema="urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig", endpoint="/ServiceProviderConfig")
@JsonData
public class ServiceProviderConfigurationResponse
extends SCIMSchema {
    public static final int MAXIMUM_FILTERED_RESULTS = 200;
    @JsonExcludeNull
    @ScimAttribute(description="An HTTP addressable URL pointing to the service provider's human-consumable help documentation", required=false)
    private String documentationUri;
    @ScimAttribute(description="A complex type that specifies PATCH configuration options")
    private Supported patch;
    @ScimAttribute(description="A complex type that specifies bulk configuration options")
    private SupportedBulk bulk;
    @ScimAttribute(description="A complex type that specifies FILTER configuration options")
    private SupportedFilter filter;
    @ScimAttribute(description="A complex type that specifies password change configuration options")
    private Supported changePassword;
    @ScimAttribute(description="A complex type that specifies sort configuration options")
    private Supported sort;
    @ScimAttribute(description="A complex type that specifies ETag configuration options")
    private Supported etag;
    @ScimAttribute(description="A list of supported authentication schemes", required=false, multiValued=true)
    private List<AuthenticationScheme> authenticationSchemes = new ArrayList<AuthenticationScheme>();

    public ServiceProviderConfigurationResponse() {
        this.patch = Supported.NOT_IS_SUPPORTED;
        this.bulk = new SupportedBulk(false, 1000, 0x100000);
        this.filter = new SupportedFilter(true, 200);
        this.changePassword = Supported.NOT_IS_SUPPORTED;
        this.sort = Supported.NOT_IS_SUPPORTED;
        this.etag = Supported.NOT_IS_SUPPORTED;
    }

    @JsonData
    public static class Supported {
        public static transient Supported IS_SUPPORTED = new Supported(true);
        public static transient Supported NOT_IS_SUPPORTED = new Supported(false);
        @ScimAttribute(description="Indicates if this feature is supported")
        private boolean supported;

        private Supported(boolean supported) {
            this.supported = supported;
        }
    }

    @JsonData
    public static class SupportedBulk
    extends Supported {
        @ScimAttribute(description="The maximum number of operations")
        private int maxOperations;
        @ScimAttribute(description="The maximum payload size in bytes")
        private int maxPayloadSize;

        private SupportedBulk(boolean supported, int maxOperations, int maxPayloadSize) {
            super(supported);
            this.maxOperations = maxOperations;
            this.maxPayloadSize = maxPayloadSize;
        }
    }

    @JsonData
    public static class SupportedFilter
    extends Supported {
        @ScimAttribute(description="The maximum number of results")
        private int maxResults;

        private SupportedFilter(boolean supported, int maxResults) {
            super(supported);
            this.maxResults = maxResults;
        }
    }
}

