/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.annotations.JsonField;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import java.util.List;

@ScimSchema(name="ListResponse", schema="urn:ietf:params:scim:api:messages:2.0:ListResponse")
@JsonData
public class ListResponse
extends SCIMSchema {
    @ScimAttribute(description="The total number of results returned by the list operation")
    private int totalResults;
    @JsonExcludeNull
    @ScimAttribute(description="The 1-based index of the first result in the current set of list results", required=false)
    private Integer startIndex;
    @JsonExcludeNull
    @ScimAttribute(description="The number of items returned per page in the current set of list results", required=false)
    private Integer itemsPerPage;
    @JsonExcludeNull
    @JsonField(name="Resources")
    @ScimAttribute(description="The list of SCIM resources returned by the list operation")
    private List<?> resources;

    private ListResponse() {
    }

    public static ListResponse from(List<?> resources) {
        ListResponse listResponse = new ListResponse();
        listResponse.resources = resources;
        listResponse.totalResults = resources.size();
        return listResponse;
    }

    public static ListResponse from(List<?> resources, int startIndex, int itemsPerPage, int totalResults) {
        ListResponse listResponse = ListResponse.from(resources);
        listResponse.startIndex = startIndex;
        listResponse.itemsPerPage = itemsPerPage;
        listResponse.totalResults = totalResults;
        return listResponse;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public List<?> getResources() {
        return this.resources;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }
}

