/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.base;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.http.servlet.SessionStore;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.types.a;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SCIMMeta {
    private static transient SimpleDateFormat DATE_FORMATER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    @ScimAttribute(description="The resource type name", mutability=a.readOnly, caseExact=true)
    private String resourceType;
    @JsonExcludeNull
    @ScimAttribute(description="The DateTime when the resource was created", required=false)
    private String created;
    @JsonExcludeNull
    @ScimAttribute(description="The DateTime when the resource was last modified", required=false)
    private String lastModified;
    @JsonExcludeNull
    @ScimAttribute(description="The URL location to access this resource", required=false)
    private String location;
    @JsonExcludeNull
    @ScimAttribute(description="The version of the resource")
    private String version;

    private SCIMMeta() {
    }

    public SCIMMeta(ScimSchema schema) {
        this.resourceType = schema.name();
        this.location = SCIMMeta.getResourceLocation(SessionStore.getHttpServletRequest(), schema.endpoint());
    }

    public void setCreated(Date created) {
        this.created = DATE_FORMATER.format(created);
    }

    public void setLastModified(long lastModified) {
        this.lastModified = DATE_FORMATER.format(Date.from(Instant.ofEpochMilli(lastModified)));
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void updateLocation(String location) {
        this.location = SCIMMeta.getResourceLocation(SessionStore.getHttpServletRequest(), location);
    }

    public void addLocationId(String id) {
        this.location = this.location + "/" + id;
    }

    public String getLocation() {
        return this.location;
    }

    private static String getResourceLocation(@Nullable HttpServletRequest request, @Nonnull String location) {
        if (!((String)location).startsWith("/")) {
            location = "/" + (String)location;
        }
        if (!((String)location).startsWith("/api/scim/v2")) {
            location = "/api/scim/v2" + (String)location;
        }
        if (request == null) {
            return "." + (String)location;
        }
        return String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + ProxyHttpServletRequest.getContextPath((HttpServletRequest)request) + (String)location;
    }
}

