/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.group;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMMeta;
import com.inet.plugin.scim.webapi.data.base.SCIMMultiValue;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.user.UserResource;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@ScimSchema(description="User Groups", name="Group", schema="urn:ietf:params:scim:schemas:core:2.0:Group", endpoint="/Groups")
@JsonData
public class GroupResource
extends SCIMSchema.SCIMBasicAttributes {
    @ScimAttribute(description="A human-readable name for the Group.", required=true)
    private String displayName;
    @ScimAttribute(description="A list of members of the Group.", multiValued=true)
    private List<SCIMMultiValue> members = new ArrayList<SCIMMultiValue>();

    private GroupResource() {
    }

    @Nonnull
    public static GroupResource minimal(@Nonnull UserGroupInfo group) {
        GroupResource groupResource = new GroupResource();
        SCIMMeta sCIMMeta = groupResource.getMeta();
        sCIMMeta.addLocationId(group.getID().toString());
        sCIMMeta.setLastModified(group.getLastModified());
        groupResource.id = group.getID().toString();
        groupResource.displayName = group.getDisplayName();
        groupResource.externalId = groupResource.id;
        return groupResource;
    }

    @Nonnull
    public static GroupResource from(@Nonnull UserGroupInfo group) {
        GroupResource groupResource = GroupResource.minimal(group);
        UserManager userManager = UserManager.getInstance();
        for (GUID gUID : group.getMemberIDs()) {
            UserAccount userAccount = userManager.getUserAccount(gUID);
            UserResource userResource = UserResource.fromUser(userAccount);
            String string = userResource.getMeta().getLocation();
            groupResource.members.add(new SCIMMultiValue(userAccount.getID().toString(), userAccount.getDisplayName(), string));
        }
        return groupResource;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<SCIMMultiValue> getMembers() {
        return this.members;
    }
}

