/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.handler.groups;

import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.scim.webapi.c;
import com.inet.plugin.scim.webapi.data.ListResponse;
import com.inet.plugin.scim.webapi.data.PatchOperationRequest;
import com.inet.plugin.scim.webapi.data.base.SCIMMultiValue;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.group.GroupResource;
import com.inet.plugin.scim.webapi.handler.groups.b;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends c<GroupResource> {
    public a() {
        super("Groups");
        this.registerRequestHandler(new b());
    }

    public String getHelpPageKey() {
        return "webapi.scim.v2.groups";
    }

    @Override
    @Nullable
    public List<? extends SCIMSchema> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull List<? extends SCIMSchema> list, List<String> list2, boolean bl) throws IOException {
        int n;
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        String string = httpServletRequest.getMethod();
        if (string == null) {
            string = "get";
        }
        switch (string.toLowerCase()) {
            case "patch": {
                list2 = this.a(httpServletRequest, httpServletResponse, list, this.a(httpServletResponse, list2));
                break;
            }
            case "put": {
                list2 = this.b(httpServletRequest, httpServletResponse, list, this.a(httpServletResponse, list2));
                break;
            }
            case "post": {
                list2 = this.a(httpServletRequest, httpServletResponse, list);
                break;
            }
            case "delete": {
                UserGroupManager.getInstance().deleteGroup(this.a(httpServletResponse, list2).getID());
                httpServletResponse.setStatus(204);
                return null;
            }
        }
        if (list2.size() > 0) {
            return List.of(GroupResource.from(this.a(httpServletResponse, list2)));
        }
        Object object = new ArrayList();
        String string2 = httpServletRequest.getParameter("startIndex");
        String string3 = httpServletRequest.getParameter("count");
        TreeSet treeSet = new TreeSet((userGroupInfo, userGroupInfo2) -> userGroupInfo.getID().compareTo(userGroupInfo2.getID()));
        treeSet.addAll(userGroupManager.getAllGroups());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        int n3 = 0;
        int n4 = StringFunctions.isEmpty((String)string2) || string2 == null ? 0 : Math.max(0, Integer.valueOf(string2) - 1);
        int n5 = n = StringFunctions.isEmpty((String)string3) || string3 == null ? 200 : Math.max(0, Integer.valueOf(string3));
        while (iterator.hasNext() && ++n2 - n4 <= Math.min(n, 200)) {
            UserGroupInfo userGroupInfo3 = (UserGroupInfo)iterator.next();
            if (n4 > n2) continue;
            ++n3;
            object.add(GroupResource.from(userGroupInfo3));
        }
        return List.of(ListResponse.from(object, n4 + 1, n3, treeSet.size()));
    }

    @Nonnull
    private UserGroupInfo a(@Nonnull HttpServletResponse httpServletResponse, @Nonnull List<String> list) {
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        UserGroupInfo userGroupInfo = null;
        if (list.size() == 0) {
            httpServletResponse.setStatus(404);
            throw new ClientMessageException("Resource not found for empty path.");
        }
        userGroupInfo = userGroupManager.getGroup(GUID.valueOf((String)list.get(0)));
        if (userGroupInfo == null) {
            httpServletResponse.setStatus(404);
            throw new ClientMessageException("Resource not found: '" + list.get(0) + "'.");
        }
        return userGroupInfo;
    }

    private List<String> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull List<? extends SCIMSchema> list, @Nonnull UserGroupInfo userGroupInfo) {
        PatchOperationRequest patchOperationRequest = list.stream().filter(sCIMSchema -> PatchOperationRequest.class.isAssignableFrom(sCIMSchema.getClass())).map(sCIMSchema -> (PatchOperationRequest)sCIMSchema).findFirst().orElse(null);
        if (patchOperationRequest == null) {
            throw new ClientMessageException("The given data is not a valid Patch Request");
        }
        for (PatchOperationRequest.PatchOperation patchOperation : patchOperationRequest.getOperations()) {
            if (!patchOperation.getPath().startsWith("members")) {
                throw new ClientMessageException("Patch operations on the group requires the 'members' path to be used");
            }
            if (!"members".equals(patchOperation.getPath())) {
                throw new ClientMessageException("Patch operations on the group do not support filters.");
            }
            List<GUID> list2 = null;
            PatchOperationRequest.a a2 = patchOperation.getOp();
            switch (a2) {
                case r: {
                    list2 = new ArrayList<GUID>(userGroupInfo.getMemberIDs());
                    list2.forEach(gUID -> UserGroupManager.getInstance().removeUserFromGroup(gUID, userGroupInfo.getID(), new MembershipType[0]));
                }
                case p: {
                    list2 = this.a(patchOperation);
                    if (list2 == null) {
                        throw new ClientMessageException("Patch operation 'remove' on the group require the 'value' path to be a string or list of maps with a 'value' key.");
                    }
                    list2.forEach(gUID -> UserGroupManager.getInstance().addUserToGroup(gUID, userGroupInfo.getID(), new MembershipType[0]));
                    break;
                }
                case q: {
                    list2 = this.a(patchOperation);
                    if (list2 == null) {
                        list2 = new ArrayList<GUID>(userGroupInfo.getMemberIDs());
                    }
                    list2.forEach(gUID -> UserGroupManager.getInstance().removeUserFromGroup(gUID, userGroupInfo.getID(), new MembershipType[0]));
                }
            }
        }
        return List.of(userGroupInfo.getID().toString());
    }

    @Nullable
    private List<GUID> a(PatchOperationRequest.PatchOperation patchOperation) {
        List<Object> list = null;
        if (patchOperation.getValue() instanceof String) {
            list = List.of(GUID.valueOf((String)((String)patchOperation.getValue())));
        } else if (patchOperation.getValue() instanceof List) {
            list = ((List)patchOperation.getValue()).stream().map(map -> GUID.valueOf((String)((String)map.get("value")))).filter(gUID -> UserManager.getInstance().getUserAccount(gUID) != null).collect(Collectors.toList());
        }
        return list;
    }

    private List<String> b(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull List<? extends SCIMSchema> list, UserGroupInfo userGroupInfo) {
        GroupResource groupResource = list.stream().filter(sCIMSchema -> GroupResource.class.isAssignableFrom(sCIMSchema.getClass())).map(sCIMSchema -> (GroupResource)sCIMSchema).findFirst().orElse(null);
        if (groupResource == null) {
            throw new ClientMessageException("The given data is not a valid Group");
        }
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        if (!StringFunctions.isEmpty((String)groupResource.getDisplayName())) {
            userGroupManager.renameGroup(userGroupInfo.getID(), groupResource.getDisplayName());
        }
        userGroupInfo.getMemberIDs().forEach(gUID -> userGroupManager.removeUserFromGroup(gUID, userGroupInfo.getID(), new MembershipType[0]));
        this.a(userGroupInfo.getID(), groupResource);
        return List.of(userGroupInfo.getID().toString());
    }

    private void a(GUID gUID, GroupResource groupResource) {
        List<SCIMMultiValue> list = groupResource.getMembers();
        for (SCIMMultiValue sCIMMultiValue : list) {
            GUID gUID2 = GUID.valueOf((String)sCIMMultiValue.getValue());
            UserGroupManager.getInstance().addUserToGroup(gUID2, gUID, new MembershipType[0]);
        }
    }

    private List<String> a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nonnull List<? extends SCIMSchema> list) {
        GroupResource groupResource = list.stream().filter(sCIMSchema -> GroupResource.class.isAssignableFrom(sCIMSchema.getClass())).map(sCIMSchema -> (GroupResource)sCIMSchema).findFirst().orElse(null);
        if (groupResource == null) {
            throw new ClientMessageException("The given data is not a valid Group");
        }
        GUID gUID = GUID.generateNew();
        MutableUserGroupData mutableUserGroupData = MutableUserGroupData.createAndFillWithValidValues((GUID)gUID, Collections.emptyList(), Collections.emptyMap());
        gUID = UserGroupManager.getInstance().createGroup(groupResource.getDisplayName(), UsersAndGroups.GROUPTYPE_STANDARD, mutableUserGroupData);
        this.a(gUID, groupResource);
        httpServletResponse.setStatus(201);
        return List.of(gUID.toString());
    }

    public boolean isMethodAllowedForData(HttpServletRequest request) {
        return super.isMethodAllowedForData(request) || "PATCH".equals(request.getMethod());
    }

    public boolean isAllowedWithoutAuthentication() {
        return false;
    }
}

