/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.schema;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import com.inet.plugin.scim.webapi.data.schema.SchemaAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

@ScimSchema(name="Schema", schema="urn:ietf:params:scim:schemas:core:2.0:Schema", description="Schema definition", endpoint="/Schemas")
@JsonData
public class SchemaDataResponse
extends SCIMSchema.SCIMBasicAttributes {
    static final String SCIM_IDENTIFIER = "urn:ietf:params:scim:schemas:core:2.0:Schema";
    @JsonExcludeNull
    @ScimAttribute(description="The schema's name", required=false)
    private String name;
    @JsonExcludeNull
    @ScimAttribute(description="The schema's description", required=false)
    private String description;
    @ScimAttribute(description="A list of attributes for the schema", multiValued=true)
    private List<SchemaAttribute> attributes = new ArrayList<SchemaAttribute>();
    @ScimAttribute(description="A list of schemas suported", multiValued=true)
    private List<String> schemas = List.of("urn:ietf:params:scim:schemas:core:2.0:Schema");

    public String getId() {
        return this.id;
    }

    public List<SchemaAttribute> getAttributes() {
        return this.attributes;
    }

    public static SchemaDataResponse from(Class<? extends SCIMSchema> type) {
        SchemaDataResponse schemaDataResponse = new SchemaDataResponse();
        ScimSchema scimSchema = SCIMSchema.getSCIMSchemaForClass(type);
        schemaDataResponse.id = scimSchema.schema();
        schemaDataResponse.name = StringFunctions.isEmpty((String)scimSchema.name()) ? null : scimSchema.name();
        schemaDataResponse.description = StringFunctions.isEmpty((String)scimSchema.description()) ? null : scimSchema.description();
        schemaDataResponse.getMeta().updateLocation(schemaDataResponse.getScimSchema().endpoint() + "/" + scimSchema.schema());
        List<Field> list = SchemaDataResponse.getAllFields(type);
        for (Field field : list) {
            schemaDataResponse.attributes.add(SchemaAttribute.from(field));
        }
        schemaDataResponse.attributes.removeIf(e -> e == null);
        return schemaDataResponse;
    }

    public static List<Field> getAllFields(Class<? extends SCIMSchema> type) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                arrayList.add(field);
            }
            Class<? extends SCIMSchema> object = type.getSuperclass();
            type = object != null && SCIMSchema.class.isAssignableFrom(object) ? type.getSuperclass() : null;
        }
        return arrayList;
    }
}

