/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMSchema;
import java.util.List;

@ScimSchema(name="Bulk", schema="urn:ietf:params:scim:api:messages:2.0:BulkRequest")
@JsonData
public class BulkRequest
extends SCIMSchema {
    @ScimAttribute(description="The number of errors returned when processing a bulk request")
    private int failOnErrors;
    @ScimAttribute(description="Operations to be performed in bulk")
    private List<Operation> operations;

    protected BulkRequest() {
    }

    @JsonData
    public static class Operation {
        @ScimAttribute(description="The HTTP method for the operation")
        private String method;
        @ScimAttribute(description="The ID for the operation within the bulk request")
        private String bulkId;
        @ScimAttribute(description="The version of the resource being operated on", required=false)
        private String version;
        @ScimAttribute(description="The path to the resource endpoint for the operation")
        private String path;
        @ScimAttribute(description="The data payload for the operation")
        private SCIMSchema data;
        @ScimAttribute(description="The location URL of the created resource after a successful operation", required=false)
        private String location;
        @JsonExcludeNull
        @ScimAttribute(description="The response payload for the operation", required=false)
        private SCIMSchema response;
        @JsonExcludeNull
        @ScimAttribute(description="The HTTP status code of the operation response", required=false)
        private Integer status;
    }
}

