/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.scim.webapi.data.base;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.scim.webapi.annotations.ScimAttribute;
import com.inet.plugin.scim.webapi.annotations.ScimSchema;
import com.inet.plugin.scim.webapi.data.base.SCIMMeta;
import com.inet.plugin.scim.webapi.data.base.types.a;
import com.inet.plugin.scim.webapi.data.base.types.b;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;

@JsonData
public abstract class SCIMSchema
implements NamedExtension {
    private transient ScimSchema scimSchema = this.getClass().getAnnotation(ScimSchema.class);

    public SCIMSchema() {
        if (this.scimSchema == null) {
            throw new IllegalArgumentException("The class '" + String.valueOf(this.getClass()) + "' must have the ScimSchema annotation.");
        }
    }

    @Nonnull
    public String getExtensionName() {
        return this.scimSchema.schema();
    }

    public ScimSchema getScimSchema() {
        return this.scimSchema;
    }

    @Nonnull
    public static ScimSchema getSCIMSchemaForClass(@Nonnull Class<? extends SCIMSchema> clazz) {
        try {
            Constructor<? extends SCIMSchema> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]).getScimSchema();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to initialize class name", exception);
        }
    }

    @Nonnull
    public static String getSCIMSchemaIDForClass(@Nonnull Class<? extends SCIMSchema> clazz) {
        return SCIMSchema.getSCIMSchemaForClass(clazz).schema();
    }

    @JsonData
    public static abstract class SCIMBasicAttributes
    extends SCIMSchema {
        @ScimAttribute(description="Unique identifier for the resource", returned=b.Always, mutability=a.readOnly)
        protected String id;
        @JsonExcludeNull
        @ScimAttribute(description="Identifier for the resource as defined by the provisioning client", returned=b.Always, mutability=a.readWrite, caseExact=true)
        protected String externalId;
        @ScimAttribute(description="Metadata about the resource", mutability=a.readOnly)
        protected SCIMMeta meta;

        protected SCIMBasicAttributes() {
            this.meta = new SCIMMeta(this.getScimSchema());
        }

        public SCIMBasicAttributes(ScimSchema schema) {
            this.id = schema.name();
            this.meta = new SCIMMeta(schema);
        }

        public SCIMMeta getMeta() {
            return this.meta;
        }
    }
}

