/*
 * Decompiled with CFR 0.152.
 */
package com.inet.translations;

import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.permissions.Permission;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.remote.gui.IModule;
import com.inet.theme.server.ThemeResource;
import com.inet.translations.server.c;
import com.inet.translations.server.d;
import com.inet.translations.server.event.b;
import com.inet.translations.server.provider.GoogleTranslationsProvider;
import com.inet.translations.server.provider.a;
import java.net.URL;

@PluginInfo(id="translations", group="applications", dependencies="remotegui", optionalDependencies="theme;maintenance", version="25.10.217", icon="com/inet/translations/resources/img/translations_48.png", flags="optional")
public class TranslationsServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "translations";
    public static final I18nMessages MSG = new I18nMessages("com.inet.translations.resources.i18n.LanguageResources", TranslationsServerPlugin.class);
    public static final Logger LOGGER = LogManager.getLogger((String)"Translations");

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl(PLUGIN_ID, 9452, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
    }

    public void registerExtension(ServerPluginManager spm) {
        spm.register(IModule.class, (Object)new d());
        spm.register(PluginServlet.class, (Object)new c());
        spm.register(a.class, (Object)new GoogleTranslationsProvider());
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(TranslationsServerPlugin.class, "resources/js/translations-controller.js");
        combinedFile.add(TranslationsServerPlugin.class, "resources/js/translations-factory.js");
        combinedFile.add(TranslationsServerPlugin.class, "resources/js/translations-model.js");
        combinedFile.add(TranslationsServerPlugin.class, "resources/js/translations-filter.js");
        combinedFile.add(TranslationsServerPlugin.class, "resources/js/translations-renderer.js");
        combinedFile.addMessages(MSG);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "translationsCore.js", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("resources/translation-language-header.html")});
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "translation-language-header.html", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[]{this.getClass().getResource("resources/translation-running-in-the-cloud-header.html")});
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "translation-running-in-the-cloud-header.html", combinedFile));
        spm.register(WebSocketEvent.class, (Object)new com.inet.translations.server.event.c());
        spm.register(WebSocketEvent.class, (Object)new b());
        spm.register(WebSocketEvent.class, (Object)new com.inet.translations.server.event.a());
        if (spm.isPluginLoaded("theme")) {
            spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", this.getClass().getResource("resources/css/translation.less")));
        }
        combinedFile = new FileCombiner.CombinedFile("text/css", new URL[0]);
        combinedFile.add(TranslationsServerPlugin.class, "resources/css/translation.css");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile));
        LOGGER.debug((Object)"Translations plug-in is registered successfully.");
        if (spm.isPluginLoaded("maintenance")) {
            spm.register(BackupTask.class, (Object)new com.inet.translations.backup.a());
        }
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }
}

