/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal.validation;

import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessValidationException;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TicketBranch {
    private final List<Activity> activities = new ArrayList<Activity>();
    private final ParallelTicket pt;
    private final Set<TicketBranch> allPaths;

    public TicketBranch(Set<TicketBranch> allPaths, ParallelTicket pt, TicketProcess process) {
        this.allPaths = allPaths;
        this.pt = pt;
        allPaths.add(this);
        this.addAll(this.activities, pt == null ? process.getStart() : pt.getStart(), process);
    }

    private void addAll(List<Activity> collection, Activity a, TicketProcess process) {
        if (collection.contains(a)) {
            return;
        }
        if (this.isUsedInOtherBranch(a)) {
            throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.usedByMultiplePaths", new Object[]{a.getName()}), process, a);
        }
        collection.add(a);
        for (ActivityTransition tra : a.getFollowUpActivities()) {
            Activity nextActivity = tra.getNextActivity();
            if (nextActivity == a) {
                throw new ProcessValidationException(TicketProcessManager.MSG.getMsg("validation.activity.cannotTransitToSelf", new Object[]{a.getName()}), process, a);
            }
            this.addAll(collection, nextActivity, process);
        }
    }

    private boolean isUsedInOtherBranch(Activity a) {
        for (TicketBranch branch : this.allPaths) {
            if (!branch.activities.contains(a)) continue;
            return true;
        }
        return false;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public ParallelTicket getPt() {
        return this.pt;
    }
}

