/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.internal;

import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.Locale;

public enum ProcessTicketEventLog {
    ProcessStarted,
    ProcessLeft;

    private static final EventLog<ProcessTicketEventLog> EVENT_LOG;

    public void log(TicketProcess process, int ticketId) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String msg = TicketProcessManager.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{ticketId, process.getName()});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", process.getName());
        data.put("ID", process.getId().toString());
        data.put("Ticket-ID", String.valueOf(ticketId));
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{ticketId});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdeskticket");
    }
}

