/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class ProcessTicketData {
    private Map<TicketField<?>, ProcessValueReference<?, ?>> map = new HashMap();

    public <VALUE> void putRef(TicketField<VALUE> field, @Nonnull ProcessValueReference<?, ?> value) {
        if (value.hasConcreteValue() && !ProcessValueReference.isDateField(field)) {
            try {
                field.validate(value.getValue());
            }
            catch (FieldValidationException ex) {
                throw new FieldValidationException(field.getLabel(ClientLocale.getThreadLocale()) + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.map.put(field, value);
    }

    public <VALUE> void put(TicketField<VALUE> field, Object value) {
        if (ProcessValueReference.isDateField(field) && value != null && !(value instanceof RelativeOrAbsoluteDate)) {
            throw new FieldValidationException("Must pass in a RelativeOrAbsoluteDate for dates!");
        }
        this.putRef(field, ProcessValueReference.createConcrete(field, value));
    }

    public <FIELDTYPE, VALUE> ProcessValueReference<FIELDTYPE, VALUE> get(TicketField<FIELDTYPE> field) {
        return this.map.get(field);
    }

    public void remove(TicketField<?> field) {
        this.map.remove(field);
    }

    public boolean containsKey(TicketField<?> field) {
        return this.map.containsKey(field);
    }

    public Set<TicketField<?>> getIncludedFields() {
        return new HashSet(this.map.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public ProcessTicketData copy() {
        ProcessTicketData copy = new ProcessTicketData();
        copy.putAll(this);
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessTicketData other = (ProcessTicketData)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessTicketData:[");
        sb.append(this.map.toString()).append("]");
        return sb.toString();
    }

    public void putAll(ProcessTicketData ticketData) {
        this.map.putAll(ticketData.map);
    }
}

