/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.extensions.SetAttributesDirectlyExtension;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.FieldValidationException;
import java.io.NotActiveException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

@InternalApi
public class ProcessTools {
    public static void setProcessAndActivityOfTicket(int ticketId, TicketProcess ticketProcess, GUID activityId) {
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        attributes.put(TicketProcessManager.ATTRIBUTE_ACTIVITY, (Object)activityId);
        attributes.put(TicketProcessManager.ATTRIBUTE_PROCESS, (Object)ticketProcess);
        List<GUID> visitedActivities = ProcessTools.findPathToCurrentActivity(ticketProcess.getStart(), activityId, new ArrayList<GUID>(), new HashSet<GUID>());
        attributes.put(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES, visitedActivities == null ? Collections.emptyList() : visitedActivities);
        SetAttributesDirectlyExtension.silentlySetAttributesOfTicket(ticketId, attributes);
    }

    public static ParallelTicket parallelTicketHoldingActivity(GUID activity, TicketProcess ticketProcess) {
        for (ParallelTicket pt : ticketProcess.getParallelTickets()) {
            List<Activity> activities = pt.getActivities();
            if (!activities.stream().anyMatch(a -> a.getId().equals((Object)activity))) continue;
            return pt;
        }
        return null;
    }

    public static Activity startActivityOfBranchHoldingActivity(GUID activity, TicketProcess ticketProcess) {
        if (ticketProcess.getActivities().stream().anyMatch(a -> a.getId().equals((Object)activity))) {
            return ticketProcess.getStart();
        }
        for (ParallelTicket pt : ticketProcess.getParallelTickets()) {
            List<Activity> activities = pt.getActivities();
            if (!activities.stream().anyMatch(a -> a.getId().equals((Object)activity))) continue;
            return pt.getStart();
        }
        return null;
    }

    public static List<GUID> findPathToCurrentActivity(Activity a, GUID activeActivityId) {
        return ProcessTools.findPathToCurrentActivity(a, activeActivityId, new ArrayList<GUID>(), new HashSet<GUID>());
    }

    private static List<GUID> findPathToCurrentActivity(Activity a, GUID activeActivityId, List<GUID> set, Set<GUID> visited) {
        if (a.getId().equals((Object)activeActivityId)) {
            set.add(a.getId());
            return set;
        }
        if (visited.contains(a.getId())) {
            return null;
        }
        visited.add(a.getId());
        set = new ArrayList<GUID>(set);
        set.add(a.getId());
        for (ActivityTransition tra : a.getFollowUpActivities()) {
            List<GUID> r = ProcessTools.findPathToCurrentActivity(tra.getNextActivity(), activeActivityId, set, visited);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static <FIELDTYPE> FIELDTYPE getValueFromProcessTicketData(TicketField<FIELDTYPE> f, ProcessTicketData ticketData, Supplier<ProcessTickets> processTickets) throws NotActiveException {
        ProcessValueReference value = ticketData.get(f);
        Object valueSuffix = null;
        if (value.hasConcreteValue()) {
            Object value2 = value.getValue();
            if (value2 instanceof RelativeOrAbsoluteDate) {
                return (FIELDTYPE)Long.valueOf(((RelativeOrAbsoluteDate)value2).toAbsoluteDate());
            }
            valueSuffix = value2;
        }
        Object resolvedValue = null;
        if (value.hasReferenceValue()) {
            GUID targetTicket = value.getParallelTicketId();
            ProcessTickets processTickets2 = processTickets.get();
            if (targetTicket == null) {
                resolvedValue = processTickets2.getMainTicket().getValue(f);
            } else {
                TicketVO ticketVO = processTickets2.getSubTickets().get(targetTicket);
                if (ticketVO == null) {
                    throw new NotActiveException();
                }
                resolvedValue = ticketVO.getValue(f);
            }
        }
        switch (value.getReferenceType()) {
            case 1: {
                return (FIELDTYPE)valueSuffix;
            }
            case 2: {
                return (FIELDTYPE)resolvedValue;
            }
            case 3: {
                String suffix = valueSuffix == null ? "" : valueSuffix.toString();
                String valueStr = resolvedValue == null ? "" : resolvedValue.toString();
                Object newSubject = valueStr + " " + suffix;
                try {
                    f.validate(newSubject);
                }
                catch (FieldValidationException ex) {
                    newSubject = suffix.length() == 255 ? suffix : valueStr.substring(0, Math.min(254 - suffix.length(), valueStr.length())) + " " + suffix;
                }
                return (FIELDTYPE)newSubject;
            }
        }
        throw new UnsupportedOperationException("ProcessValueReference.Type=" + value.getReferenceType());
    }

    public static MutableTicketData processDataToMutableTicketData(ProcessTicketData ticketData, Supplier<ProcessTickets> processTickets) {
        MutableTicketData result = new MutableTicketData();
        for (TicketField<?> f : ticketData.getIncludedFields()) {
            try {
                result.put(f, ProcessTools.getValueFromProcessTicketData(f, ticketData, processTickets));
            }
            catch (NotActiveException notActiveException) {}
        }
        return result;
    }
}

