/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.handler;

import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.helpdesk.plugins.ticketlist.api.data.TicketValue;
import com.inet.helpdesk.plugins.ticketlist.api.ticketlistlayout.TicketListLayoutManager;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ParallelTicketPreviewRequest;
import com.inet.helpdesk.plugins.ticketprocess.client.data.ParallelTicketPreviewResponse;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcessProgress;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class ParallelTicketPreview
extends ServiceMethod<ParallelTicketPreviewRequest, ParallelTicketPreviewResponse> {
    public ParallelTicketPreviewResponse invoke(HttpServletRequest req, HttpServletResponse resp, ParallelTicketPreviewRequest payload) throws IOException {
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        TicketProcessProgress.ProgressTicketData progressTicketData = ticketProcessManager.getProgressTicketDataFor(payload.getMainTicketId(), payload.getParallelTicketId());
        HashMap<String, TicketValue> ticketDetails = new HashMap<String, TicketValue>();
        List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        List columns = TicketListLayoutManager.getInstance().getAllAvailableColumns(false);
        TicketVOSingle ticket = TicketVOSingle.create((int)0, (MutableTicketAttributes)progressTicketData.getAttributes(), (MutableTicketData)progressTicketData.getData());
        for (TicketFieldDefinition fieldDefinition : ticketFieldDefinitions) {
            String hyperlink;
            if (Tickets.ATTRIBUTE_TICKET_ID.getKey().equals(fieldDefinition.getKey())) continue;
            String displayValue = fieldDefinition.getDisplayValue((TicketVO)ticket);
            String valueAsString = fieldDefinition.supportsIcon() ? fieldDefinition.getValueAsStringForIcon((TicketVO)ticket) : null;
            String string = hyperlink = fieldDefinition instanceof TicketFieldDefinitionWithHyperlink && ((TicketFieldDefinitionWithHyperlink)fieldDefinition).isLinkField() ? ((TicketFieldDefinitionWithHyperlink)fieldDefinition).getHyperlink((TicketVO)ticket) : null;
            if (StringFunctions.isEmpty((String)displayValue) && StringFunctions.isEmpty((String)valueAsString) && StringFunctions.isEmpty((String)hyperlink)) continue;
            ticketDetails.put(fieldDefinition.getKey(), new TicketValue(valueAsString, displayValue, fieldDefinition.getDescription((TicketVO)ticket), hyperlink));
        }
        String htmlContent = "";
        ReaStepTextVO stepText = progressTicketData.getText();
        String text = stepText.getText();
        if (stepText.hasHtmlContent()) {
            htmlContent = TicketTextFunctions.getInlinedHtml((String)text, (boolean)true);
        } else if (!text.isBlank()) {
            htmlContent = TicketTextFunctions.getLightHtmlFromPlainText((String)text);
        }
        return new ParallelTicketPreviewResponse(columns, ticketDetails, htmlContent);
    }

    public short getMethodType() {
        return 1;
    }

    public String getMethodName() {
        return "ticketprocess.parallelticket.preview";
    }
}

