/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.plugin.setup;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.internal.TicketProcessManagerImpl;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.setup.quickticketbyprocess.TicketFieldProcessId;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TicketProcessMigrationSetupStep
extends AutoSetupStep {
    private static final StepKey KEY = new StepKey("ticketprocess.migration");
    private final Map<Integer, GUID> oldProcessToNewProcess = new HashMap<Integer, GUID>();
    private final Map<String, GUID> oldActivityToNewActivity = new HashMap<String, GUID>();

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return TicketProcessManager.MSG.getMsg("TicketProcessMigrationSetupStep.displayName", new Object[0]);
    }

    public boolean hasPendingTasks() {
        try {
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)"tblProzesse")) {
                return true;
            }
        }
        catch (SQLException t) {
            SetupLogger.LOGGER.debug((Object)t);
        }
        catch (Throwable e) {
            SetupLogger.LOGGER.error(e);
        }
        return false;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        ResultSet rs;
        Statement statement;
        Connection c;
        DatabaseConnectionFactory f = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
        TicketProcessManager ticketProcessManager = (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        try {
            c = f.getConnectionFromCurrentConfiguration();
            try {
                statement = c.createStatement();
                try {
                    rs = statement.executeQuery("select * from tblProzesse where geloescht = 0");
                    try {
                        while (rs.next()) {
                            String json = rs.getString(3);
                            Integer proID = rs.getInt(1);
                            TicketProcess ticketProcess = this.createProcessFromJson(proID, ticketProcessManager, json);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        catch (ClassNotFoundException | SQLException throwables) {
            throw new StepExecutionException((Throwable)throwables);
        }
        try {
            c = f.getConnectionFromCurrentConfiguration();
            try {
                statement = c.createStatement();
                try {
                    rs = statement.executeQuery("select BunID, ProID, Task from tblBuendel where ProID IS NOT NULL and ProID > 0");
                    try {
                        while (rs.next()) {
                            int buendelID = rs.getInt(1);
                            int proID = rs.getInt(2);
                            String task = rs.getString(3);
                            GUID newProcess = this.oldProcessToNewProcess.get(proID);
                            GUID newTask = this.oldActivityToNewActivity.get(proID + ";" + task);
                            if (newProcess != null && newTask != null) {
                                TicketProcess process = ticketProcessManager.getProcess(newProcess);
                                if (process != null) {
                                    ProcessTools.setProcessAndActivityOfTicket(buendelID, process, newTask);
                                    continue;
                                }
                                SetupLogger.LOGGER.warn((Object)("TicketProcessMigrationSetupStep: process unknown: " + String.valueOf(newProcess)));
                                continue;
                            }
                            SetupLogger.LOGGER.warn((Object)("TicketProcessMigrationSetupStep: old process or task unknown: " + proID + " ; " + task));
                        }
                        this.dropMigratedColumns();
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        catch (Exception throwables) {
            throw new StepExecutionException((Throwable)throwables);
        }
        this.migrationActionProcessInQuickTickets();
    }

    private void dropMigratedColumns() throws StepExecutionException {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String dbConfigs = configuration.get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null) {
            return;
        }
        DatabaseConfigInfo databaseConfigInfo = ((DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class)).get("HDS");
        DatabaseConnectionFactory f = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
        try (Connection connection = f.getConnectionFromCurrentConfiguration();
             Statement statement = connection.createStatement();){
            if (databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.inetdae7) {
                try {
                    PreparedStatement pst = connection.prepareStatement("DECLARE @sql NVARCHAR(MAX)\nWHILE 1=1\nBEGIN\n    SELECT TOP 1 @sql = N'alter table tblBuendel drop constraint ['+dc.NAME+N']'\n    from sys.default_constraints dc\n    JOIN sys.columns c\n        ON c.default_object_id = dc.object_id\n    WHERE \n        dc.parent_object_id = OBJECT_ID('tblBuendel')\n    AND c.name = N'ProID'\n    IF @@ROWCOUNT = 0 BREAK\n    EXEC (@sql)\nEND");
                    pst.executeUpdate();
                    statement.executeUpdate("DROP INDEX \"tblBuendelProzess\" ON tblBuendel");
                    statement.executeUpdate("ALTER TABLE tblBuendel DROP CONSTRAINT tblProzesse_tblBuendel_FK");
                }
                catch (SQLException throwables) {
                    SetupLogger.LOGGER.warn((Object)throwables);
                }
            } else if (databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.mysql || databaseConfigInfo.getDriver() == DatabaseConfigInfo.DatabaseType.mariadb) {
                try {
                    statement.executeUpdate("ALTER TABLE tblBuendel DROP FOREIGN KEY tblProzesse_tblBuendel_FK");
                }
                catch (SQLException throwables) {
                    SetupLogger.LOGGER.warn((Object)throwables);
                }
            } else {
                try {
                    statement.executeUpdate("ALTER TABLE tblBuendel DROP CONSTRAINT TBLPROZESSE_TBLBUENDEL");
                }
                catch (SQLException throwables) {
                    SetupLogger.LOGGER.warn((Object)throwables);
                }
            }
            statement.executeUpdate("ALTER TABLE tblBuendel DROP COLUMN Task");
            statement.executeUpdate("ALTER TABLE tblBuendel DROP COLUMN ProID");
            statement.executeUpdate("DROP TABLE tblProzesse");
        }
        catch (ClassNotFoundException | SQLException throwables) {
            throw new StepExecutionException((Throwable)throwables);
        }
    }

    public TicketProcess createProcessFromJson(int proID, TicketProcessManager ticketProcessManager, String json) {
        if (StringFunctions.isEmpty((String)json)) {
            return null;
        }
        Map map = (Map)new Json().fromJson(json, Map.class);
        String nameOfReactivateAction = ((ActionVO)ActionManager.getInstance().get(-2)).getDisplayValue();
        if (map.get("isValid") == Boolean.TRUE) {
            Object linksObj;
            String processName = (String)map.get("name");
            GUID startActivityID = null;
            ArrayList<Supplier<Activity>> activities = new ArrayList<Supplier<Activity>>();
            GUID stopProcessActivityID = GUID.generateNew();
            Activity stopProcessActivity = new Activity(stopProcessActivityID, null, Activity.Type.FinishProcess, new ArrayList<String>(), new ArrayList<ActivityTransition>(), "Stop", "Migration: Dies ist eine Anlehnung an das Verhalten bis zur Version 22.4, wo beim Reaktivieren der Prozess entfernt wurde. Wenn der Prozess auch beim Reaktivieren fortgef\u00fchrt werden soll, kann diese Aktivit\u00e4t entfernt und beim Reaktivieren zu einer anderen Aktivit\u00e4t gewechselt werden.", new ArrayList<Integer>(), new ProcessTicketData());
            activities.add(() -> stopProcessActivity);
            HashMap nameToTransitions = new HashMap();
            HashMap<String, GUID> nameToGUID = new HashMap<String, GUID>();
            Object list = map.get("tasks");
            if (list instanceof List) {
                List tasks = (List)list;
                for (Object taskMap : tasks) {
                    GUID resourceGroupUUID;
                    Integer resID;
                    String name = (String)taskMap.get("name");
                    String info = (String)taskMap.get("info");
                    GUID activityID = GUID.generateNew();
                    ArrayList<ActivityTransition> followUpActivities = new ArrayList<ActivityTransition>();
                    ProcessTicketData ticketData = new ProcessTicketData();
                    Map resource = (Map)taskMap.get("resource");
                    if (resource != null && (resID = (Integer)resource.get("id")) != null && (resourceGroupUUID = HDUsersAndGroups.getResourceGroupUUID((int)resID)) != null) {
                        ticketData.put(Tickets.FIELD_RESOURCE_GUID, resourceGroupUUID);
                    }
                    ArrayList<Integer> actions = new ArrayList<Integer>(((List)taskMap.get("actions")).stream().map(m -> (Integer)m.get("id")).filter(a -> ActionManager.getInstance().get(a.intValue()) != null).collect(Collectors.toList()));
                    actions.add(5);
                    actions.add(-6);
                    actions.add(-21);
                    actions.add(-31);
                    actions.add(-22);
                    actions.add(-26);
                    actions.add(-27);
                    actions.add(-28);
                    actions.add(-12);
                    actions.add(7);
                    actions.add(-19);
                    actions.add(-30);
                    actions.add(-25);
                    actions.add(-29);
                    actions.add(-35);
                    if (taskMap.get("start") == Boolean.TRUE) {
                        startActivityID = activityID;
                    }
                    if (actions.contains(2)) {
                        followUpActivities.add(new ActivityTransition(stopProcessActivityID, nameOfReactivateAction, -2));
                    }
                    nameToTransitions.put(name, followUpActivities);
                    nameToGUID.put(name, activityID);
                    activities.add(() -> new Activity(activityID, null, Activity.Type.Standard, new ArrayList<String>(), followUpActivities, name, info, actions, ticketData));
                    this.oldActivityToNewActivity.put(proID + ";" + name, activityID);
                }
            }
            if ((linksObj = map.get("links")) instanceof List) {
                List links = (List)linksObj;
                for (Map link : links) {
                    String fromTask = (String)link.get("fromTask");
                    String toTask = (String)link.get("toTask");
                    int actionId = (Integer)link.get("actionId");
                    List transitions = (List)nameToTransitions.get(fromTask);
                    transitions.add(new ActivityTransition((GUID)nameToGUID.get(toTask), "", actionId));
                }
            }
            List<Activity> activityObjects = activities.stream().map(s -> (Activity)s.get()).collect(Collectors.toList());
            if (startActivityID == null) {
                startActivityID = ((Activity)activityObjects.get(0)).getId();
            }
            GUID guid = GUID.generateNew();
            if (StringFunctions.isEmpty((String)processName)) {
                processName = guid.toString();
            }
            TicketProcess process = new TicketProcess(guid, processName, null, activityObjects, startActivityID, Collections.emptyList(), TicketProcess.AdditionalResourceAccess.NONE, false);
            try {
                ticketProcessManager.createProcess(process);
                this.oldProcessToNewProcess.put(proID, process.getId());
                SetupLogger.LOGGER.info((Object)("[Process] Migrated Process " + processName));
            }
            catch (ClientMessageException exc) {
                SetupLogger.LOGGER.warn((Object)"[Process] Possibly running this setup migration again?? If so ignore already existing processes");
                SetupLogger.LOGGER.warn((Object)exc);
            }
            return process;
        }
        StepExecutionWarnings.get().warn(() -> TicketProcessManager.MSG.getMsg("TicketProcessMigrationSetupStep.InvalidProcess", new Object[]{map.get("name")}));
        SetupLogger.LOGGER.warn((Object)("[Process] Could not migrate invalid(!) task '" + String.valueOf(map.get("name")) + "'"));
        return null;
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5978);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> TicketProcessManager.MSG.getMsg("TicketProcessMigrationSetupStep.executing", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrationActionProcessInQuickTickets() {
        block14: {
            if (ServerPluginManager.getInstance().isPluginLoaded("quickticket")) {
                SetupLogger.LOGGER.info((Object)"[Process] Check for Processes started in QuickTickets.");
                TicketFieldProcessId processIdField = new TicketFieldProcessId();
                DynamicExtensionManager.getInstance().register(TicketField.class, (Object)processIdField);
                try (UserAccountScope p = UserAccountScope.createPrivileged();){
                    String uniqueIDOfEditReaText = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
                    String uniqueIDOfApplyProcess = ((ActionVO)ActionManager.getInstance().get(-19)).getUniqueID();
                    QuickTicketManager manager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
                    TicketProcessManagerImpl processManager = TicketProcessManagerImpl.INSTANCE;
                    for (GUID qtID : manager.getAllQuickTicketIDs()) {
                        QuickTicketVO vo = manager.getQuickTicket(qtID);
                        MutableTicketData ticketData = vo.getTicketData();
                        if (!ticketData.containsKey((TicketField)processIdField)) continue;
                        Integer processId = (Integer)ticketData.get((TicketField)processIdField);
                        GUID processGUID = this.oldProcessToNewProcess.get(processId);
                        if (processGUID == null) {
                            SetupLogger.LOGGER.warn((Object)("[Process] Cannot find process with ID " + processId));
                            continue;
                        }
                        TicketProcess process = processManager.getProcess(processGUID);
                        if (process == null) {
                            SetupLogger.LOGGER.warn((Object)("[Process] Really cannot find process with ID " + String.valueOf(processGUID)));
                            continue;
                        }
                        ArrayList<ApplicableActionDataVO> actionsData = new ArrayList<ApplicableActionDataVO>(vo.getActionsData());
                        int indexToAdd = 0;
                        if (!actionsData.isEmpty() && ((ApplicableActionDataVO)actionsData.get(0)).getUniqueActionID().equals(uniqueIDOfEditReaText)) {
                            indexToAdd = 1;
                        }
                        ExtensionArguments args = ExtensionArguments.ofSingleArg(TicketProcessManager.EXT_ARG_PROCESS_TO_START, (Object)process.toActiveProcessWithoutModifications());
                        actionsData.add(indexToAdd, ApplicableActionDataVO.create((String)uniqueIDOfApplyProcess, (MutableReaStepData)new MutableReaStepData(), (ReaStepTextVO)ReaStepTextVO.empty(), (ExtensionArguments)args));
                        manager.updateQuickTicket(QuickTicketVO.create((GUID)qtID, (String)vo.getQuickTicketName(), (MutableTicketData)ticketData, (ExtensionArguments)vo.getExtensionArguments(), actionsData));
                        SetupLogger.LOGGER.info((Object)("[Process] Updated QuickTicket " + vo.getQuickTicketName()));
                    }
                    break block14;
                }
                finally {
                    DynamicExtensionManager.getInstance().unregister(TicketField.class, (Object)processIdField);
                }
            }
            SetupLogger.LOGGER.info((Object)"[Process] QuickTicket plugin is not active");
        }
    }
}

