/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProcessTickets {
    private final TicketVO mainTicket;
    private final Map<GUID, TicketVO> subTickets;
    private final TicketProcess process;

    private ProcessTickets(TicketVO ticket, TicketProcess process) {
        this.process = process;
        Integer mainTicketId = (Integer)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
        this.mainTicket = mainTicketId != null ? TicketManager.getReaderForSystem().getTicket(mainTicketId.intValue()) : ticket;
        HashMap<GUID, TicketVO> subTickets = new HashMap<GUID, TicketVO>();
        for (Map.Entry sub : ((Map)this.mainTicket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).entrySet()) {
            subTickets.put((GUID)sub.getKey(), TicketManager.getReaderForSystem().getTicket(((Integer)sub.getValue()).intValue()));
        }
        this.subTickets = Collections.unmodifiableMap(subTickets);
    }

    public ProcessTickets(OperationChangedTicket ticket, TicketProcess process) {
        Optional<OperationChangedTicket> optional;
        this.process = process;
        TicketOperationModel model = ticket.getParentModel();
        Integer mainTicketId = (Integer)ticket.getAttributeValue(TicketProcessManager.ATTRIBUTE_MAIN_TICKET);
        this.mainTicket = mainTicketId != null ? ((optional = model.getChangedTickets().stream().filter(oct -> oct.getTicketId() == mainTicketId.intValue()).findFirst()).isPresent() ? optional.get().createIntermediateTicketVO() : TicketManager.getReaderForSystem().getTicket(mainTicketId.intValue())) : ticket.createIntermediateTicketVO();
        HashMap<GUID, TicketVO> subTickets = new HashMap<GUID, TicketVO>();
        for (Map.Entry sub : ((Map)this.mainTicket.getAttribute(TicketProcessManager.ATTRIBUTE_CHILD_TICKETS)).entrySet()) {
            Optional<OperationChangedTicket> optional2 = model.getChangedTickets().stream().filter(oct -> oct.getTicketId() == ((Integer)sub.getValue()).intValue()).findFirst();
            if (optional2.isPresent()) {
                subTickets.put((GUID)sub.getKey(), optional2.get().createIntermediateTicketVO());
                continue;
            }
            subTickets.put((GUID)sub.getKey(), TicketManager.getReaderForSystem().getTicket(((Integer)sub.getValue()).intValue()));
        }
        this.subTickets = Collections.unmodifiableMap(subTickets);
    }

    public static ProcessTickets createOldSnapshot(TicketVO ticketOfProcess) {
        TicketProcess p = TicketProcessManager.getProcessOfTicket(ticketOfProcess);
        if (p == null) {
            throw new IllegalStateException("Process cannot be null");
        }
        return new ProcessTickets(ticketOfProcess, p);
    }

    public Set<TicketVO> allTickets() {
        HashSet<TicketVO> hashSet = new HashSet<TicketVO>(this.subTickets.values());
        hashSet.add(this.mainTicket);
        return hashSet;
    }

    public TicketVO getMainTicket() {
        return this.mainTicket;
    }

    public Map<GUID, TicketVO> getSubTickets() {
        return this.subTickets;
    }

    public TicketProcess getProcess() {
        return this.process;
    }
}

