/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.ProcessTools;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ParallelTicket;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessProgressingConditionValue;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProcessTickets;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.condition.ProgressingCondition;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.helpdesk.shared.model.Status;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import java.text.NumberFormat;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ConditionType<V> {
    public static final ConditionType<ProcessProgressingConditionValue> TICKET_FINISHED = new ProgressingCondition(){

        @Override
        public boolean resolve0(ProcessProgressingConditionValue value, ProcessTickets tickets) {
            TicketVO ticketVO = tickets.getSubTickets().get(value.getItemId());
            if (ticketVO == null) {
                return false;
            }
            return Status.isClosedOrDeletedStatus((int)ticketVO.getStatusID());
        }

        @Override
        public String getTypeIdentifier() {
            return "ticketFinished";
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process) {
            return TicketProcessManager.MSG.getMsg("condition.ticketFinished", new Object[]{"'" + process.getParallelTicket(value.getItemId()).getName() + "'"});
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process, ProcessTickets currentState) {
            TicketVO ticketVO = currentState.getSubTickets().get(value.getItemId());
            if (ticketVO != null) {
                return TicketProcessManager.MSG.getMsg("condition.ticketFinished", new Object[]{ConditionType.ticketIdString(ticketVO)});
            }
            return super.getDisplayString(value, process, currentState);
        }
    };
    public static final ConditionType<ProcessProgressingConditionValue> ACTIVITY_FINISHED = new ProgressingCondition(){

        @Override
        public boolean resolve0(ProcessProgressingConditionValue value, ProcessTickets tickets) {
            GUID activityId = value.getItemId();
            Predicate<TicketVO> check = ticket -> ((List)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES)).contains(activityId) && !((GUID)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_ACTIVITY)).equals((Object)activityId);
            if (tickets.getProcess().getActivities().stream().anyMatch(a -> a.getId().equals((Object)activityId))) {
                return check.test(tickets.getMainTicket());
            }
            for (ParallelTicket pt : tickets.getProcess().getParallelTickets()) {
                if (!pt.getActivities().stream().anyMatch(a -> a.getId().equals((Object)activityId))) continue;
                TicketVO ticket2 = tickets.getSubTickets().get(pt.getId());
                return ticket2 != null && check.test(ticket2);
            }
            TicketProcessPlugin.LOGGER.warn((Object)("Activity used in condition does not exists: " + String.valueOf(activityId)));
            return false;
        }

        @Override
        public String getTypeIdentifier() {
            return "activityFinished";
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process) {
            ParallelTicket pt = ProcessTools.parallelTicketHoldingActivity(value.getItemId(), process);
            String name = pt == null ? TicketProcessManager.MSG.getMsg("validation.mainTicket", new Object[0]) : TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{"'" + pt.getName() + "'"});
            return TicketProcessManager.MSG.getMsg("condition.activityFinished", new Object[]{process.getActivity(value.getItemId()).getName(), name});
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process, ProcessTickets currentState) {
            ParallelTicket pt = ProcessTools.parallelTicketHoldingActivity(value.getItemId(), process);
            TicketVO ticketVO = pt == null ? currentState.getMainTicket() : currentState.getSubTickets().get(pt.getId());
            if (ticketVO != null) {
                String name = TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{ConditionType.ticketIdString(ticketVO)});
                return TicketProcessManager.MSG.getMsg("condition.activityFinished", new Object[]{process.getActivity(value.getItemId()).getName(), name});
            }
            return super.getDisplayString(value, process, currentState);
        }
    };
    public static final ConditionType<ProcessProgressingConditionValue> ACTIVITY_VISITED = new ProgressingCondition(){

        @Override
        public boolean resolve0(ProcessProgressingConditionValue value, ProcessTickets tickets) {
            GUID activityId = value.getItemId();
            Predicate<TicketVO> check = ticket -> ((List)ticket.getAttribute(TicketProcessManager.ATTRIBUTE_VISITED_ACTIVITIES)).contains(activityId);
            if (tickets.getProcess().getActivities().stream().anyMatch(a -> a.getId().equals((Object)activityId))) {
                return check.test(tickets.getMainTicket());
            }
            for (ParallelTicket pt : tickets.getProcess().getParallelTickets()) {
                if (!pt.getActivities().stream().anyMatch(a -> a.getId().equals((Object)activityId))) continue;
                TicketVO ticket2 = tickets.getSubTickets().get(pt.getId());
                return ticket2 != null && check.test(ticket2);
            }
            TicketProcessPlugin.LOGGER.warn((Object)("Activity used in condition does not exists: " + String.valueOf(activityId)));
            return false;
        }

        @Override
        public String getTypeIdentifier() {
            return "activityVisited";
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process) {
            ParallelTicket pt = ProcessTools.parallelTicketHoldingActivity(value.getItemId(), process);
            String name = pt == null ? TicketProcessManager.MSG.getMsg("validation.mainTicket", new Object[0]) : TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{"'" + pt.getName() + "'"});
            return TicketProcessManager.MSG.getMsg("condition.activityVisited", new Object[]{process.getActivity(value.getItemId()).getName(), name});
        }

        @Override
        public String getDisplayString(ProcessProgressingConditionValue value, TicketProcess process, ProcessTickets currentState) {
            ParallelTicket pt = ProcessTools.parallelTicketHoldingActivity(value.getItemId(), process);
            TicketVO ticketVO = pt == null ? currentState.getMainTicket() : currentState.getSubTickets().get(pt.getId());
            if (ticketVO != null) {
                String name = TicketProcessManager.MSG.getMsg("validation.parallelTicket", new Object[]{ConditionType.ticketIdString(ticketVO)});
                return TicketProcessManager.MSG.getMsg("condition.activityVisited", new Object[]{process.getActivity(value.getItemId()).getName(), name});
            }
            return super.getDisplayString(value, process, currentState);
        }
    };
    public static final ConditionType<Void> ALL_TICKETS_FINISHED = new ConditionType<Void>(){

        @Override
        public boolean resolve(Void value, ProcessTickets tickets) {
            for (TicketVO t : tickets.getSubTickets().values()) {
                if (Status.isClosedOrDeletedStatus((int)t.getStatusID())) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getTypeIdentifier() {
            return "allTicketsFinished";
        }

        @Override
        public String getDisplayString(Void value, TicketProcess process) {
            return TicketProcessManager.MSG.getMsg("condition.allTicketsFinished", new Object[0]);
        }

        @Override
        public Class<Void> getValueType() {
            return Void.class;
        }
    };

    public String getTypeIdentifier();

    public boolean resolve(V var1, ProcessTickets var2);

    public String getDisplayString(V var1, TicketProcess var2);

    default public String getDisplayString(V value, TicketProcess process, ProcessTickets currentState) {
        return this.getDisplayString(value, process);
    }

    @Nullable
    default public V convert(String data) {
        if (data == null) {
            return null;
        }
        return (V)IOFunctions.fromJsonNullable((String)data, this.getValueType());
    }

    public Class<V> getValueType();

    default public String convert(V value) {
        if (value == null) {
            return null;
        }
        return new Json().toJson(value);
    }

    public static String ticketIdString(@Nonnull TicketVO ticketVO) {
        return "#" + NumberFormat.getIntegerInstance(ClientLocale.getThreadLocale()).format(ticketVO.getID());
    }
}

