/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.general.RelativeOrAbsoluteDate;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActivityTransition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessTicketData;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessValueReference;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.plugin.TicketProcessPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class Activity {
    private GUID id;
    private String name;
    private String description;
    private GUID nextProcessToStart;
    private Type type;
    private List<String> requiredFieldKeys;
    private List<ActivityTransition> followUpActivities;
    private List<Integer> allowedActions;
    private ProcessTicketData processTicketData;
    private transient Map<String, String> ticketDataToSetAtStart;
    private ReaStepTextVO ticketText;
    private boolean appendTextOfMainTicketIntoParallel;
    private int weight = 10;

    private Activity() {
    }

    public Activity(GUID id, GUID nextProcessToStart, Type type, List<String> requiredFieldKeys, List<ActivityTransition> followUpActivities, String name, String description, List<Integer> possibleActions, ProcessTicketData incomingTicketData) {
        this(id, nextProcessToStart, type, requiredFieldKeys, followUpActivities, name, description, possibleActions, incomingTicketData, 10, null);
    }

    public Activity(GUID id, List<ActivityTransition> followUpActivities, String name, String description, List<Integer> possibleActions, ProcessTicketData incomingTicketData, ReaStepTextVO parallelTicketText, boolean appendTextOfMainTicketIntoParallel) {
        this(id, null, Type.Standard, Collections.emptyList(), followUpActivities, name, description, possibleActions, incomingTicketData, 10, parallelTicketText);
        Objects.requireNonNull(parallelTicketText);
        this.appendTextOfMainTicketIntoParallel = appendTextOfMainTicketIntoParallel;
    }

    Activity(GUID id, GUID nextProcessToStart, Type type, List<String> requiredFieldKeys, List<ActivityTransition> followUpActivities, String name, String description, List<Integer> possibleActions, ProcessTicketData incomingTicketData, int weight, ReaStepTextVO parallelTicketText) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        Objects.requireNonNull(requiredFieldKeys, "requiredFields cannot be null, pass empty list");
        Objects.requireNonNull(followUpActivities, "followUpActivities cannot be null, pass empty list");
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(possibleActions, "possibleActions cannot be null, pass empty list");
        Objects.requireNonNull(incomingTicketData, "incomingTicketData cannot be null");
        this.ticketText = parallelTicketText;
        this.id = id;
        this.nextProcessToStart = nextProcessToStart;
        this.type = type;
        this.requiredFieldKeys = new ArrayList<String>(requiredFieldKeys);
        this.followUpActivities = new ArrayList<ActivityTransition>(followUpActivities);
        this.name = name;
        this.weight = weight;
        this.description = description;
        this.allowedActions = new ArrayList<Integer>(possibleActions);
        this.processTicketData = incomingTicketData.copy();
    }

    @Nonnull
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public List<Integer> getPossibleActions() {
        return Collections.unmodifiableList(this.allowedActions);
    }

    public ProcessTicketData getIncomingTicketData() {
        return this.processTicketData.copy();
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getRequiredFieldKeys() {
        return Collections.unmodifiableList(this.requiredFieldKeys);
    }

    public List<ActivityTransition> getFollowUpActivities() {
        return Collections.unmodifiableList(this.followUpActivities);
    }

    public GUID getId() {
        return this.id;
    }

    public GUID getNextProcessToStart() {
        return this.nextProcessToStart;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public ReaStepTextVO getTicketText() {
        return this.ticketText;
    }

    public boolean isAppendTextOfMainTicketIntoParallel() {
        return this.appendTextOfMainTicketIntoParallel;
    }

    void restoreReferences(List<Activity> activities, TicketProcess process) {
        for (ActivityTransition activityTransition : this.followUpActivities) {
            activityTransition.restoreReferences(activities, process, this);
        }
        if (this.processTicketData == null && this.ticketDataToSetAtStart != null) {
            this.processTicketData = new ProcessTicketData();
            for (Map.Entry entry : this.ticketDataToSetAtStart.entrySet()) {
                try {
                    Object value;
                    TicketField f = TicketField.valueOf((String)((String)entry.getKey()));
                    if (f == null) continue;
                    Object object = value = entry.getValue() == null ? null : new Json().fromJson((String)entry.getValue(), f.getValueType());
                    if (ProcessValueReference.isDateField(f) && value != null) {
                        value = RelativeOrAbsoluteDate.createRelative((long)((Long)value * 60L * 1000L));
                    }
                    this.processTicketData.putRef(f, ProcessValueReference.createConcrete(f, value));
                }
                catch (Exception json) {
                    TicketProcessPlugin.LOGGER.warn((Object)("Incompatible field in activity " + this.name + " of process " + process.getName()));
                    TicketProcessPlugin.LOGGER.warn((Object)json);
                }
            }
        }
        this.processTicketData.remove(null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedActions == null ? 0 : this.allowedActions.hashCode());
        result = 31 * result + (this.appendTextOfMainTicketIntoParallel ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.followUpActivities == null ? 0 : this.followUpActivities.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nextProcessToStart == null ? 0 : this.nextProcessToStart.hashCode());
        result = 31 * result + (this.processTicketData == null ? 0 : this.processTicketData.hashCode());
        result = 31 * result + (this.requiredFieldKeys == null ? 0 : this.requiredFieldKeys.hashCode());
        result = 31 * result + (this.ticketText == null ? 0 : this.ticketText.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activity other = (Activity)obj;
        if (this.allowedActions == null ? other.allowedActions != null : !this.allowedActions.equals(other.allowedActions)) {
            return false;
        }
        if (this.appendTextOfMainTicketIntoParallel != other.appendTextOfMainTicketIntoParallel) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.followUpActivities == null ? other.followUpActivities != null : !this.followUpActivities.equals(other.followUpActivities)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nextProcessToStart == null ? other.nextProcessToStart != null : !this.nextProcessToStart.equals((Object)other.nextProcessToStart)) {
            return false;
        }
        if (this.processTicketData == null ? other.processTicketData != null : !this.processTicketData.equals(other.processTicketData)) {
            return false;
        }
        if (this.requiredFieldKeys == null ? other.requiredFieldKeys != null : !this.requiredFieldKeys.equals(other.requiredFieldKeys)) {
            return false;
        }
        if (this.ticketText == null ? other.ticketText != null : !this.ticketText.equals((Object)other.ticketText)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.weight == other.weight;
    }

    public String toString() {
        return "Activity [id=" + String.valueOf(this.id) + ", name=" + this.name + ", description=" + this.description + ", nextProcessToStart=" + String.valueOf(this.nextProcessToStart) + ", type=" + String.valueOf((Object)this.type) + ", requiredFieldKeys=" + String.valueOf(this.requiredFieldKeys) + ", followUpActivities=" + String.valueOf(this.followUpActivities) + ", allowedActions=" + String.valueOf(this.allowedActions) + ", ticketDataToSetAtStart=" + String.valueOf(this.ticketDataToSetAtStart) + ", weight=" + this.weight + "]";
    }

    public static enum Type {
        Standard,
        FinishProcess;

    }
}

