/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.ticketprocess.client.ticketlist;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ProcessRef;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepProcessGrouping
extends AdditionalReaStepFieldDefinition<ProcessRef> {
    public AdditionalReaStepProcessGrouping() {
        super(TicketProcessManager.REASTEP_FIELD_PROCESS);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        ProcessRef process = (ProcessRef)step.getValue(TicketProcessManager.REASTEP_FIELD_PROCESS);
        if (process == null) {
            return null;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return null;
        }
        if (!SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION}) && !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return null;
        }
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        HashMap<String, Object> linkValues = new HashMap<String, Object>();
        if (SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION}) && ((TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class)).getProcess(process.getId()) != null) {
            linkValues.put("url", "configmanager/page/configuration.ticketprocess/editprocess/" + String.valueOf(process.getId()));
            linkValues.put("title", TicketProcessManager.MSG.getMsg("ticketlist.additionalreastepfield.openProcess", new Object[]{process.getName()}));
        } else {
            linkValues.put("title", TicketProcessManager.MSG.getMsg("ticketlist.additionalreastepfield.activeProcess", new Object[]{process.getName()}));
        }
        linkValues.put("iconclass", "icon-additionalreastepfield-process");
        list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
        return list;
    }
}

